package com.ejianc.foundation.message.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.SocketMessageLogEntity;
import com.ejianc.foundation.message.service.ISocketMessageService;
import com.ejianc.foundation.message.vo.SocketMessageLogVO;
import com.ejianc.foundation.message.vo.SocketMsgParameter;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

@RestController
@RequestMapping("/api/message/")
public class SocketMessageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISocketMessageService websocket;

    @PostMapping(value = "sendWebsocketMessage")
    public CommonResponse<Map<String, Long>> pushWebsocketMessage(@RequestBody SocketMsgParameter parameter){
        logger.info("收到待发Socket消息：{}",JSONObject.toJSONString(parameter));
        Map<String, Long> msgIds = new HashMap<>();
        String sendUrl = baseHost + "ejc-webpush/event/send";
        for(String userId : parameter.getReceivers()) {
            Long msgId = IdWorker.getId();
            //4、向用户所有有效的会话发送打开应用指令
            Map<String, String> userSessions = sessionManager.getUserSessionMap(Long.valueOf(userId));
            JSONObject tabParam = new JSONObject();
            tabParam.put("msgType", parameter.getMsgType());
            tabParam.put("msgTitle", parameter.getSubject());
            tabParam.put("msgId", msgId.toString());
            tabParam.put("pcUrl", parameter.getPcUrl());
//            tabParam.put("keyContent", parameter.getKeyContent());
            tabParam.put("keyValueContent", parameter.getKeyValueContent());
            tabParam.put("pcTitle", parameter.getPcTitle());
            tabParam.put("mobileUrl", parameter.getMobileUrl());
            tabParam.put("attachIds",parameter.getAttachIds());
            tabParam.put("content",parameter.getContent());
            tabParam.put("msgState",parameter.getState());
            for(String token : userSessions.keySet()) {
                Map<String, String> paramMap = new HashMap<>();
                paramMap.put("token", token);
                paramMap.put("type", "sysMsg");
                paramMap.put("value", tabParam.toJSONString());
                try {
                    logger.info("向webpush发送websocket消息url:{}, 参数：{}", sendUrl, JSON.toJSONString(paramMap));
                    HttpTookit.postByJson(sendUrl, JSON.toJSONString(paramMap));
                } catch (Exception e) {
                    logger.error("向webpush发送消息失败；", e);
                }
            }
            SocketMessageLogEntity message = new SocketMessageLogEntity();
            message.setContent(tabParam.toJSONString());
            message.setId(msgId);
            message.setState(parameter.getState());
            message.setUserId(Long.valueOf(userId));
            message.setSendTime(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND, new Date()));
            message.setMsgType(SocketMessageLogVO.ROBOT);
            if(InvocationInfoProxy.getTenantid()==null){
                message.setTenantId(parameter.getTenantId()!=null?Long.parseLong(parameter.getTenantId()):999999);
            }
            websocket.saveOrUpdate(message,false);
            msgIds.put(userId, msgId);
            logger.info("sys消息转socket消息持久化成功：{}", JSON.toJSONString(message));
        }
        return CommonResponse.success(msgIds);
    }

    @PostMapping(value = "updateWebsocketMessageStatus")
    public CommonResponse<String> updateWebsocketMessageStatus(@RequestBody List<Long> msgIds){
        String sendUrl = baseHost + "ejc-webpush/event/send";
        logger.info("更新websocket消息状态：{}",JSON.toJSONString(msgIds));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, msgIds));
        List<SocketMessageLogEntity> list = websocket.queryList(queryParam,false);
        for(SocketMessageLogEntity entity : list){
            entity.setState(SocketMessageLogVO.DONE);
            websocket.saveOrUpdate(entity,false);
            Map<String, String> userSessions = sessionManager.getUserSessionMap(entity.getUserId());
            JSONObject tabParam = new JSONObject();
            tabParam.put("msgType", "updateMsgState");
            tabParam.put("msgId", entity.getId().toString());
            tabParam.put("msgState",SocketMessageLogVO.DONE);
            for(String token : userSessions.keySet()) {
                Map<String, String> paramMap = new HashMap<>();
                paramMap.put("token", token);
                paramMap.put("type", "sysMsg");
                paramMap.put("value", tabParam.toJSONString());
                try {
                    logger.info("向webpush发送websocket 更新消息状态消息url:{}, 参数：{}", sendUrl, JSON.toJSONString(paramMap));
                    HttpTookit.postByJson(sendUrl, JSON.toJSONString(paramMap));
                } catch (Exception e) {
                    logger.error("向webpush 更新消息状态消息 发送消息失败；", e);
                }
            }
        }
        return CommonResponse.success("操作成功！");
    }

}
