package com.ejianc.foundation.message.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.message.bean.MsgChannelEntity;
import com.ejianc.foundation.message.mapper.MsgChannelMapper;
import com.ejianc.foundation.message.service.IMsgChannelService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.List;

@Service
public class MsgChannelServiceImpl extends BaseServiceImpl<MsgChannelMapper, MsgChannelEntity> implements IMsgChannelService {

	@Value("${oms.tenantid}")
	private String omTenantId;

	@Override
	public List<MsgChannelEntity> queryMsgSendConfig(String tenantId, List<String> channelTypeList) {
		List<MsgChannelEntity> resp = new ArrayList<>();
		QueryWrapper<MsgChannelEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", tenantId);
		queryWrapper.in("type", channelTypeList);
		resp = baseMapper.selectList(queryWrapper);
		resp.stream().forEach(msg -> {
			channelTypeList.remove(msg.getType());
		});
		if(CollectionUtils.isNotEmpty(channelTypeList) && !omTenantId.equals(tenantId)) {
			QueryWrapper<MsgChannelEntity> omWrapper = new QueryWrapper<>();
			omWrapper.eq("tenant_id", omTenantId);
			omWrapper.in("type", channelTypeList);
			resp.addAll(baseMapper.selectList(omWrapper));
		}

		return resp;
	}
}
