package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.MessageOutLinkEntity;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.service.IMessageOutLinkService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.ZDSEmailSendVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.security.MessageDigest;
import java.util.*;

@Service("zdsEmail")
public class ZdsEmailServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(ZdsEmailServiceImpl.class);

	@Autowired
	private IUserApi userApi;

	@Value("${ejc.sms.zds.erp.appId:0}")
	private String appId;

	@Value("${ejc.sms.zds.erp.secret:0}")
	private String secret;

	@Value("${ejc.sms.zds.erp.reqHost:0}")
	private String reqHost;

	@Value("${common.env.base-host}")
	private String baseHost;

	@Value("${ejc.sms.zds.ssoReqUrl:0}")
	private String ssoReqUrl;

	@Value("${ejc.sms.zds.erp.emailTemplate:0}")
	private String defaultEmailTemplate;

	@Value("${ejc.sms.zds.erp.emailModule:0}")
	private String defaultEmailModule;

	@Value("${ejc.sms.zds.erp.defaultFrom:供应链平台}")
	private String defaultFrom;

	@Autowired
	private IMessageOutLinkService messageOutLinkService;

	private final String ZDS_EMAIL_SEND_URL = "/cefoc/yql/CreateSendEmail";

	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		List<ZDSEmailSendVO> sendList = new ArrayList<>();

		if(null != pushMsgParameter.getReceivers() && pushMsgParameter.getReceivers().length > 0) {
			CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),
					Long.parseLong(pushMsgParameter.getTenantId()));
			List<MessageOutLinkEntity> saveLinks = new ArrayList<>();

			if(userResponse.isSuccess()) {
				List<UserVO> userVos = userResponse.getData();

				if(userVos.size() > 0) {
					for(UserVO userVo:userVos) {
						if(StringUtils.isNotBlank(userVo.getUserEmail())) {
							getEmailSendParam(pushMsgParameter, userVo, sendList, messageResponseList, saveLinks);
						}else{
							logger.info("向人员【{}】发送邮件失败，人员邮箱为空",userVo.getUserName());
							MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "向人员【"+userVo.getUserName()+"】发送邮件失败，人员邮箱为空");
							messageResponseList.add(response);
						}
					}
				}

				//保存外链
				if(CollectionUtils.isNotEmpty(saveLinks)) {
					messageOutLinkService.saveOrUpdateBatch(saveLinks, saveLinks.size(), false);
				}
			}
		} else if(null != pushMsgParameter.getZdsExtEmailParams() && null != pushMsgParameter.getZdsExtEmailParams().getString("userEmails")) {
			String[] userEmails = pushMsgParameter.getZdsExtEmailParams().getString("userEmails").split(",");
			String[] userName = pushMsgParameter.getZdsExtEmailParams().getString("userNames").split(",");
			if(userEmails.length != userName.length) {
				logger.error("中电四发送邮件失败，接收人邮箱列表【{}】与接收人名称【{}】不匹配!",
						pushMsgParameter.getZdsExtEmailParams().getString("userEmails"), pushMsgParameter.getZdsExtEmailParams().getString("userNames"));
				throw new BusinessException("中电四发送邮件失败，接收人邮箱列表与接收人名称不匹配!");
			}
			UserVO tmpUser = new UserVO();
			Integer idx = 0;
			for(String email : userEmails) {
				tmpUser.setUserEmail(email);
				tmpUser.setUserName(userName[idx]);
				idx++;
				getEmailSendParam(pushMsgParameter, tmpUser, sendList, messageResponseList, null);
			}
		}

		try {
			Map<String, String> headers = getErpHeaders(appId, secret);
			String reqResp = null;
			JSONObject respJson = null;
			for (ZDSEmailSendVO zdsEmailSendVO : sendList) {
				reqResp = HttpTookit.postByJson(reqHost+ZDS_EMAIL_SEND_URL, JSONObject.toJSONString(zdsEmailSendVO), headers, HttpTookit.connTimeout, HttpTookit.readTimeout);
				respJson = JSONObject.parseObject(reqResp);

				logger.error("请求中电四发送邮件接口：请求地址-{},参数-{},header-{},结果-{}", reqHost+ZDS_EMAIL_SEND_URL,
						JSONObject.toJSONString(zdsEmailSendVO), JSONObject.toJSONString(headers), reqResp);
				if("ok".equals(respJson.getString("Status"))) {
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_SUCCESS, "向人员【"+zdsEmailSendVO.getJsonObject().get("receiverName")+"】邮件发送成功");
					messageResponseList.add(response);
				}else {
					logger.error("请求中电四发送邮件接口发送邮件失败：请求地址-{},参数-{},header-{},结果-{}", reqHost+ZDS_EMAIL_SEND_URL,
							JSONObject.toJSONString(zdsEmailSendVO), JSONObject.toJSONString(headers), reqResp);
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE,
							"调用ERP接口向人员【"+zdsEmailSendVO.getJsonObject().get("receiverName")+"】邮件发送失败！");
					messageResponseList.add(response);
				}
			}

			logger.info("发送邮件完成!");
		} catch (Exception e) {
			logger.error("邮件发送失败", e);
		}
		
		return messageResponseList;
	}

	private void getEmailSendParam(PushMsgParameter pushMsgParameter, UserVO userVo, List<ZDSEmailSendVO> sendList,
									 List<MsgSendResponse> messageResponseList, List<MessageOutLinkEntity> saveLinks) {
		ZDSEmailSendVO sendParams = null;
		if(null != pushMsgParameter.getZdsExtEmailParams() && "false".equals(pushMsgParameter.getZdsExtEmailParams().getString("defaultModule"))) {
			//自定义邮件发送
			if(null == pushMsgParameter.getZdsExtEmailParams().get("sendParam") || null == pushMsgParameter.getZdsExtEmailParams().get("jsonObject")) {
				MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "邮件发送自定义参数：【sendParam】为空");
				messageResponseList.add(response);
			} else {
				sendParams = JSONObject.parseObject(JSONObject.toJSONString(pushMsgParameter.getZdsExtEmailParams().get("sendParam")), ZDSEmailSendVO.class);
				sendList.add(sendParams);
			}
		} else { //默认邮件发送
			sendParams = new ZDSEmailSendVO();
			sendParams.setTitle(pushMsgParameter.getSubject());
			sendParams.setAddress(userVo.getUserEmail());
			sendParams.setTemplate(defaultEmailTemplate);
			sendParams.setModule(defaultEmailModule);
			sendParams.setPcTitle(pushMsgParameter.getPcTitle());
			Hashtable<String,String> templateParams = new Hashtable<>();
			templateParams.put("receiverName", userVo.getUserName());
			templateParams.put("msgContent", pushMsgParameter.getContent());

			sendParams.setJsonObject(templateParams);
			sendParams.setPcUrl(pushMsgParameter.getPcUrl());
			sendParams.setMobileUrl(pushMsgParameter.getMobileUrl());
		}
		String comeFrom = null;
		if (pushMsgParameter.getZdsExtEmailParams() != null && pushMsgParameter.getZdsExtEmailParams().getString("comeFrom") != null) {
			comeFrom = pushMsgParameter.getZdsExtEmailParams().getString("comeFrom");
		}
		sendParams.getJsonObject().put("msgLink", baseHost + ssoReqUrl);
		sendParams.getJsonObject().put("comeFrom", Optional.ofNullable(comeFrom).orElse(defaultFrom));
		//默认隐藏超链接
		sendParams.getJsonObject().put("msgLinkFlag", "hidden");
		if((null != sendParams.getPcUrl() || null != sendParams.getMobileUrl()) && null != saveLinks) {
			saveLinks.add(getLinksByEmailParam(sendParams, userVo.getId()));
		}
		sendList.add(sendParams);
	}

	private MessageOutLinkEntity getLinksByEmailParam(ZDSEmailSendVO sendParams, Long userId) {
		MessageOutLinkEntity entity = new MessageOutLinkEntity();
		entity.setUserId(userId);
		entity.setId(IdWorker.getId());
		if(StringUtils.isNotBlank(sendParams.getPcUrl())) {
			entity.setPcUrl(sendParams.getPcUrl());
		}
		if(StringUtils.isNotBlank(sendParams.getMobileUrl())) {
			entity.setMobileUrl(sendParams.getMobileUrl() + (sendParams.getMobileUrl().contains("?") ? "&userid=" : "?userid=") + userId);
		}
		entity.setExtParam1(JSONObject.toJSONString(sendParams));
		entity.setExtParam2(sendParams.getPcTitle());
		sendParams.getJsonObject().put("msgLinkFlag", "visible");
		sendParams.getJsonObject().put("msgLink", sendParams.getJsonObject().get("msgLink")+"?ticket="+entity.getId().toString());
		return entity;
	}


	public static Map<String, String> getErpHeaders(String appId, String secret) throws Exception {
		Map<String, String> headers = new HashMap<>();
		String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
		headers.put("appid", toMD5(appId));
		headers.put("ticket", nowStr);
		headers.put("sign", toMD5(secret + toMD5(appId) + toMD5(nowStr)));

		return headers;
	}

	public static String toMD5(String plainText) throws Exception {
		MessageDigest digest = MessageDigest.getInstance("MD5");
		byte[] hashBytes = digest.digest(plainText.getBytes());

		StringBuilder sb = new StringBuilder();
		for (byte b : hashBytes) {
			sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
		}

		return sb.toString().toLowerCase();
	}

}
