package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service("zdsSmsService")
public class ZdsSmsServiceImpl implements ISmsService {
	private static final Logger logger = LoggerFactory.getLogger(ZdsSmsServiceImpl.class);
	
	@Autowired
	private JedisTemplate jedis;
	@Value("${ejc.sms.zds.host:0}")
	private String smsHost;
	@Value("${ejc.sms.zds.appid:0}")
	private String appid;
	@Value("${ejc.sms.zds.secret:0}")
	private String secret;
	
	@Override
	public CommonResponse<String> sendMessage(SmsMessageParam param) {
		logger.info("发送短信参数：{}", param.toString());
		try {
			if(StringUtils.isBlank(param.getTemplateCode())) {
				return CommonResponse.error("短信模板编号不能为空！");
			}
			if(StringUtils.isBlank(param.getSignName())) {
				return CommonResponse.error("短信签名不能为空！");
			}
			if(!Validate.isMobile(param.getPhone())) {
				return CommonResponse.error("手机号不合法！");
			}
	        try {
				String rand = null != param.getParams() && null != param.getParams().get("rand") ? param.getParams().get("rand") : ProduceNumber.produce();
				String ticket = DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,new Date());

				Map<String, String> params = new HashMap<>();
				Map<String, String> headers = new HashMap<>();
				Map<String, String> paramP = param.getParams();

				JSONObject templateInfo = new JSONObject();
				if(paramP!=null){
					for (String s : paramP.keySet()) {
						templateInfo.put(s,paramP.get(s));
					}
				}
				templateInfo.put("code",rand);
				params.put("signName",param.getSignName());
				params.put("phoneNumbers",param.getPhone());
				params.put("templateCode",param.getTemplateCode());
				params.put("templateInfo",templateInfo.toJSONString());
				params.put("modelName","益企联系统");
				params.put("name","00000000-0000-0000-0000-000000000000");

				headers.put("appid",appid);
				headers.put("ticket",ticket);
				headers.put("sign",toMD5(secret+ticket+secret));

				logger.info("短信发送参数: param={} headers={}",JSONObject.toJSONString(params),JSONObject.toJSONString(headers));
				String result = HttpTookit.get(smsHost,params,headers);
	            if(StringUtils.isNotBlank(result)) {
	            	JSONObject resultJson = JSON.parseObject(result);
	            	if("ok".equals(resultJson.getString("status"))) {
						logger.info("短信发送成功！{} - {}",param.getPhone(),rand);
						jedis.setex(param.getTemplateCode()+param.getPhone(), rand, 600);
	            		return CommonResponse.success("短信发送成功！");
	            	} else {
	            		String errorMsg = resultJson.getString("info");
						logger.info("短信发送失败！{}",result);
	            		return CommonResponse.error(errorMsg);
	            	}
	            }else {
					logger.info("短信发送失败！{}-响应为空",result);
				}
	        } catch (Exception e) {
				logger.error("根据参数[{}]-发送短息异常", JSONObject.toJSONString(param));
				logger.error("发送短信异常",e);
	        }
		} catch(Exception ex) {
			logger.error("根据参数[{}]-发送短息异常", JSONObject.toJSONString(param));
			logger.error("发送短信异常",ex);
		}
		return CommonResponse.error("短信发送失败");
	}

	private static String toMD5(String plainText) {
		MessageDigest digest = null;
		try {
			digest = MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		byte[] hashBytes = digest.digest(plainText.getBytes());
		StringBuilder sb = new StringBuilder();
		for (byte b : hashBytes) {
			sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
		}
		return sb.toString().toLowerCase();
	}

}
