package com.ejianc.foundation.message.util;

import java.text.ParseException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

@Component
public class GetYonyouTokenUtils {
	// 日志
	private final static Logger logger = LoggerFactory.getLogger(GetYonyouTokenUtils.class);
	@Value("${yonYouCloud.getStaffByCodeUrl}")
	private String getStaffByCodeUrl;
	@Value("${yonYouCloud.getUserByStaffIdUrl}")
	private String getUserByStaffIdUrl;
	@Autowired
	private CacheManager cacheManager;
	@Autowired
	private IThirdSystemApi thirdSystemApi;
	
	//获取token
	public String getToken(){
		String token = null;
		try {
			logger.info("获取token开始----------------");
			CommonResponse<String> result = thirdSystemApi.getYonYouCloudAccessToken(true);
			if(result.isSuccess()){
				token = result.getData();
				cacheManager.setex("wujuToken", token, 3600);
			}
			logger.info("获取token结束----------------");
		} catch (Exception e) {
			logger.info("获取青岛市政token失败----"+e.getMessage());
			throw new BusinessException("获取青岛市政token失败----");
		}
		return token;
	}
	
	//根据usercode查询有空间用户信息
	public JSONObject getNcUser(String userCode){
		String token = cacheManager.get("wujuToken");
		if(token==null){
			token = getToken();
		}
		JSONObject userData = null;
		//根据用户code请求员工id
		String staffUrl = getStaffByCodeUrl + "?access_token="+token+"&code="+userCode;
		try {
			logger.info("serverUrl---------》"+staffUrl);
			String staffresult = HttpTookit.get(staffUrl, null, null);
			logger.info(staffresult);
			JSONObject staffjson = JSONObject.parseObject(staffresult);
			if("200".equals(staffjson.getString("code"))){
				JSONObject staffData = JSONObject.parseObject(staffjson.getString("data"));
				String staffId = staffData.getString("id");
				//根据员工id查询用户id
				String userUrl = getUserByStaffIdUrl + "?access_token="+token+"&id="+staffId;
				String userresult = HttpTookit.get(userUrl, null, null);
				JSONObject userjson = JSONObject.parseObject(userresult);
				if("200".equals(userjson.getString("code"))){
					userData = JSONObject.parseObject(userjson.getString("data"));
				}
			}else if("310036".equals(staffjson.getString("code"))){
				getToken();
				return getNcUser(userCode);
			}
			logger.info("获取友互通人员信息结束----------------");
		} catch (Exception e) {
			logger.info("获取青岛市政token失败----"+e.getMessage());
			throw new BusinessException("获取青岛市政token失败----");
		}
		return userData;
	}

    public void main(String[] args) throws ParseException {
    	String str = getToken();
    	System.out.println(str);
    	System.out.println(cacheManager.get("wujuToken").toString());
    	
    }
}
