/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.GetYonyouTokenUtils;
import com.ejianc.foundation.message.util.HttpTookit;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="wjy")
public class WjyMsgServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(WjyMsgServiceImpl.class);
    private static Gson gson = new Gson();
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${yonYouCloud.wujuTenantId:aesw7o8h}")
    private String yonTenantId;
    @Value(value="${yonYouCloud.sendMessageUrl}")
    private String sendMessageUrl;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private GetYonyouTokenUtils getYonyouTokenUtils;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        logger.info("\u4e94\u5c40\u4e91\u6d88\u606f\u53d1\u9001");
        JSONObject configJson = null;
        if (StringUtils.isNotBlank((CharSequence)configInfo)) {
            configJson = JSON.parseObject((String)configInfo);
        }
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
        logger.info("cacheManager------->" + this.cacheManager);
        String token = (String)((Object)this.cacheManager.get("wujuToken"));
        if (token == null) {
            token = this.getYonyouTokenUtils.getToken();
        }
        JSONObject wjyMsgJson = pushMsgParameter.getWjyMsgParams();
        if (userResponse.isSuccess()) {
            List userVoList = (List)userResponse.getData();
            for (UserVO userVo : userVoList) {
                JSONObject templateJson = new JSONObject();
                templateJson.put("appid", (Object)wjyMsgJson.getString("appid"));
                templateJson.put("from", (Object)wjyMsgJson.getString("from"));
                templateJson.put("msg", (Object)wjyMsgJson.getString("msg"));
                templateJson.put("msgtype", (Object)"0");
                templateJson.put("redirect", (Object)"0");
                ArrayList<String> targets = new ArrayList<String>();
                targets.add(userVo.getUserCode());
                templateJson.put("target", targets);
                templateJson.put("target_type", (Object)"users");
                String url = "";
                if (wjyMsgJson.get((Object)"url") != null) {
                    url = wjyMsgJson.getString("url");
                    url = url.replaceAll("%7Buserid%7D", userVo.getId() + "").replaceAll("%7buserid%7d", userVo.getId() + "").replaceAll("%7BuserId%7D", userVo.getId() + "").replaceAll("%7buserId%7d", userVo.getId() + "").replaceAll("\\{userid\\}", userVo.getId() + "");
                }
                templateJson.put("url", (Object)url);
                String templateContent = JSON.toJSONString((Object)templateJson);
                logger.info("-->\u4e94\u5c40\u4e91\u6d88\u606f\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)templateContent);
                String templateResult = WeixinRestUtil.doPostHttpByURL(configJson.getString("send_url"), templateContent);
                logger.info("\u4e94\u5c40\u4e91\u6d88\u606f\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)templateResult);
                JSONObject httpResult = JSON.parseObject((String)templateResult);
                if (httpResult != null) {
                    logger.info("wjy_response = " + JSON.toJSONString((Object)httpResult));
                    if ("0".equals(httpResult.get((Object)"flag"))) {
                        logger.info("\u5411" + userVo.getUserName() + "\u53d1\u9001\u4e94\u5c40\u4e91\u6d88\u606f\u6210\u529f!");
                    } else {
                        MsgSendResponse response = new MsgSendResponse("0", httpResult.getString("desc"));
                        messageResponseList.add(response);
                    }
                }
                ArrayList<String> users = new ArrayList<String>();
                JSONObject userData = this.getYonyouTokenUtils.getNcUser(userVo.getUserCode());
                if (userData != null) {
                    users.add(userData.getString("user_id"));
                }
                HashMap<String, Object> paramterMap = new HashMap<String, Object>();
                paramterMap.put("appId", IdWorker.getId());
                paramterMap.put("title", "\u8f7b\u91cf\u5316\u5e73\u53f0\u3010\u901a\u77e5\u3011");
                paramterMap.put("content", wjyMsgJson.getString("msg"));
                paramterMap.put("yhtUserIds", users);
                paramterMap.put("tenantId", this.yonTenantId);
                paramterMap.put("url", url);
                String webUrl = "";
                if (wjyMsgJson.get((Object)"webUrl") != null) {
                    webUrl = wjyMsgJson.getString("webUrl");
                    try {
                        webUrl = this.baseHost + "/portal/sso/index?userid=" + userVo.getId() + "&targeturl=" + URLEncoder.encode(wjyMsgJson.getString("webUrl"), "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                paramterMap.put("webUrl", webUrl);
                paramterMap.put("sendScope", "list");
                String serverUrl = this.sendMessageUrl + "?access_token=" + token;
                String paramterStr = gson.toJson(paramterMap);
                try {
                    logger.info("\u4f20\u9012\u7684\u53c2\u6570\uff1a---------------" + paramterStr);
                    logger.info("\u4f20\u9012\u7684serverUrl\uff1a---------------" + serverUrl);
                    String result = HttpTookit.postByJson(serverUrl, paramterStr, null);
                    logger.info("\u8c03\u7528\u4e94\u5c40\u6d88\u606f\u8fd4\u56de\u7ed3\u679c\uff1a---------------" + result);
                    JSONObject resultjson = JSONObject.parseObject((String)result);
                    if (!"310036".equals(resultjson.getString("code"))) continue;
                    token = this.getYonyouTokenUtils.getToken();
                    result = HttpTookit.postByJson(serverUrl, paramterStr, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.info("\u53d1\u9001\u4e94\u5c40\u53cb\u7a7a\u95f4\u6d88\u606f\u5931\u8d25");
                    logger.info(e.getMessage());
                }
            }
        }
        return messageResponseList;
    }
}

