/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springside.modules.nosql.redis.JedisTemplate;

@Service(value="zdsSupSmsService")
public class ZdsSupSmsServiceImpl
implements ISmsService {
    private static final Logger logger = LoggerFactory.getLogger(ZdsSupSmsServiceImpl.class);
    @Autowired
    private JedisTemplate jedis;
    @Value(value="${ejc.sms.zds.host:0}")
    private String smsHost;
    @Value(value="${ejc.sms.zds.appid:0}")
    private String appid;
    @Value(value="${ejc.sms.zds.secret:0}")
    private String secret;
    @Value(value="${ejc.sms.zds.sup.elhost:0}")
    private String ElHost;
    @Value(value="${ejc.sms.zds.sup.elappid:0}")
    private String ElAppId;
    @Value(value="${ejc.sms.zds.sup.elsecret:0}")
    private String ElSecret;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String EL_SMS_URL = "/ejc-message-web/openapi/no_auth/sms/sendMessage";

    @Override
    public CommonResponse<String> sendMessage(SmsMessageParam param) {
        logger.info("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a{}", (Object)param.toString());
        try {
            if (StringUtils.isBlank((CharSequence)param.getTemplateCode())) {
                logger.error("\u53c2\u6570-{} \u77ed\u4fe1\u6a21\u677f\u7f16\u53f7\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)param));
                return CommonResponse.error((String)"\u77ed\u4fe1\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)param.getSignName())) {
                logger.error("\u53c2\u6570-{} \u77ed\u4fe1\u7b7e\u540d\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)param));
                return CommonResponse.error((String)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!Validate.isMobile(param.getPhone())) {
                logger.error("\u53c2\u6570-{} \u624b\u673a\u53f7\u3010{}\u3011\u4e0d\u5408\u6cd5", (Object)JSONObject.toJSONString((Object)param), (Object)param.getPhone());
                return CommonResponse.error((String)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\uff01");
            }
            String rand = ProduceNumber.produce();
            param.getParams().put("rand", rand);
            logger.info("\u8c03\u7528EL\u5e73\u53f0\u77ed\u4fe1\u53d1\u9001\u53c2\u6570: param={} ElAppId={},ElSecret-{},ElHost-{}", new Object[]{JSONObject.toJSONString((Object)param), this.ElAppId, this.ElSecret, this.ElHost});
            CommonResponse smsSendResult = this.systemDataPushService.exchangeDataWithUniversal("/ejc-message-web/openapi/no_auth/sms/sendMessage", RequestMethod.POST, JSONObject.toJSONString((Object)param), this.ElAppId, this.ElSecret, this.ElHost);
            if (!smsSendResult.isSuccess()) {
                logger.error("\u8c03\u7528EL\u5e73\u53f0\u8fdb\u884c\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)smsSendResult));
                return CommonResponse.success((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
            }
            CommonResponse msgSendResult = (CommonResponse)JSONObject.parseObject((String)((String)smsSendResult.getData()), CommonResponse.class);
            if (msgSendResult.isSuccess()) {
                this.jedis.setex(param.getTemplateCode() + param.getPhone(), rand, 600);
                return CommonResponse.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01");
            }
            logger.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01{}", smsSendResult.getData());
            return CommonResponse.error((String)msgSendResult.getMsg());
        }
        catch (Exception ex) {
            logger.error("\u6839\u636e\u53c2\u6570[{}]-\u53d1\u9001\u77ed\u606f\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)param));
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)ex);
            return CommonResponse.error((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
    }

    private static String toMD5(String plainText) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }
}

