/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.HttpTookit;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="zhiyuanoa")
public class ZhiyuanoaServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(ZhiyuanoaServiceImpl.class);
    private Gson gson = new Gson();
    @Autowired
    private IUserApi userApi;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        JSONObject configJson = null;
        if (StringUtils.isNotBlank((CharSequence)configInfo)) {
            configJson = JSON.parseObject((String)configInfo);
        }
        String oaUrl = configJson.getString("oaUrl");
        String registerCode = configJson.getString("registerCode");
        String tokenUserName = configJson.getString("tokenUserName");
        String tokenPassword = configJson.getString("tokenPassword");
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
        if (userResponse.isSuccess()) {
            List userVos = (List)userResponse.getData();
            for (UserVO userVo : userVos) {
                try {
                    logger.info("\u8c03\u7528\u81f4\u8fdcoa \u63a5\u53e3\uff1a\u53d1\u9001\u6d88\u606f\u63a5\u53e3start------------------");
                    String serverUrl = oaUrl + "/seeyon/rest/thirdpartyMessage/receive/singleMessage";
                    String maurl = pushMsgParameter.getMobileUrl();
                    String pcurl = pushMsgParameter.getPcUrl();
                    if (!maurl.startsWith("http")) {
                        maurl = maurl.startsWith("/") ? this.environmentTools.getBaseHost().substring(0, this.environmentTools.getBaseHost().length() - 1) + maurl : this.environmentTools.getBaseHost() + maurl;
                    }
                    if (!pcurl.startsWith("http")) {
                        pcurl = pcurl.startsWith("/") ? this.environmentTools.getBaseHost().substring(0, this.environmentTools.getBaseHost().length() - 1) + pcurl : this.environmentTools.getBaseHost() + pcurl;
                    }
                    String content = pushMsgParameter.getContent();
                    content = content.replace("<a href=\"" + pcurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>", "");
                    content = content.replace("<a href=\"" + pcurl + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>", "");
                    maurl = this.dealUrl(maurl, userVo);
                    String jumpUrl = this.environmentTools.getBaseHost() + "portal/julisso/login?targetUrl=";
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    HashMap<String, String> paramterMap = new HashMap<String, String>();
                    paramterMap.put("thirdpartyMessageId", String.valueOf(IdWorker.getId()));
                    paramterMap.put("thirdpartyRegisterCode", registerCode);
                    paramterMap.put("messageContent", content);
                    paramterMap.put("thirdpartySenderId", userVo.getUserCode());
                    paramterMap.put("noneBindingSender", userVo.getUserCode());
                    paramterMap.put("thirdpartyReceiverId", userVo.getUserCode());
                    paramterMap.put("noneBindingReceiver", userVo.getUserCode());
                    paramterMap.put("creation_date", formatter.format(new Date()));
                    paramterMap.put("messageURL", jumpUrl + URLEncoder.encode(pcurl, "utf-8"));
                    paramterMap.put("messageH5URL", maurl);
                    logger.info("\u53d1\u9001\u6d88\u606f\u4f20\u9012\u7684\u53c2\u6570\uff1a---------------" + ((Object)paramterMap).toString());
                    String paramterStr = this.gson.toJson(paramterMap);
                    String token = this.getToken(oaUrl, tokenUserName, tokenPassword);
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("token", token);
                    String result = HttpTookit.postByJson(serverUrl, paramterStr, header);
                    logger.info("\u53d1\u9001\u81f4\u8fdcoa\u6d88\u606f\u8fd4\u56de\u7ed3\u679c\uff1a---------\u300b\u300b\u300b\u300b" + result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MsgSendResponse response = new MsgSendResponse("0", "\u81f4\u8fdcoa\u6d88\u606f\u53d1\u9001\u5931\u8d25", userVo.getUserCode());
                    logger.info("\u5411" + userVo.getUserCode() + "\u53d1\u9001\u81f4\u8fdcoa\u5931\u8d25!");
                    messageResponseList.add(response);
                }
            }
        }
        return messageResponseList;
    }

    public String getToken(String oaUrl, String tokenUserName, String tokenPassword) {
        String token = null;
        String serverUrl = oaUrl + "/seeyon/rest/token";
        try {
            logger.info("\u83b7\u53d6token\u5f00\u59cb----------------");
            HashMap<String, String> paramterMap = new HashMap<String, String>();
            paramterMap.put("userName", tokenUserName);
            paramterMap.put("password", tokenPassword);
            String paramterStr = this.gson.toJson(paramterMap);
            logger.info("serverUrl---------\u300b" + serverUrl);
            logger.info("\u53c2\u6570---------\u300b" + paramterStr);
            String result = HttpTookit.postByJson(serverUrl, paramterStr);
            logger.info(result);
            JSONObject json = JSONObject.parseObject((String)result);
            if (json.getString("id") != null && !"-1".equals(json.getString("id"))) {
                token = json.getString("id");
            }
            logger.info("\u83b7\u53d6token\u7ed3\u675f----------------");
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u9752\u5c9b\u5e02\u653ftoken\u5931\u8d25----" + e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u9752\u5c9b\u5e02\u653ftoken\u5931\u8d25----");
        }
        return token;
    }

    public String dealUrl(String url, UserVO userVo) {
        url = url.contains("userid") ? url.replaceAll("%7Buserid%7D", userVo.getId().toString()).replaceAll("%7buserid%7d", userVo.getId().toString()).replaceAll("\\{userid\\}", userVo.getId().toString()) : (url.contains("?") ? url + "&userid=" + userVo.getId().toString() : url + "?userid=" + userVo.getId().toString());
        return url;
    }
}

