package com.ejianc.foundation.message.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.SocketMessageLogEntity;
import com.ejianc.foundation.message.service.ISocketMessageService;
import com.ejianc.foundation.message.vo.SocketMessageLogVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/socket/")
public class SocketMessageController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISocketMessageService socketMessageService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * 写入消息到数据库
     *
     * @param logVO
     * @return
     */
    @PostMapping("writeSocketMsg")
    @ResponseBody
    CommonResponse<String> writeSocketMsgToDb(@RequestBody SocketMessageLogVO logVO) {
        SocketMessageLogEntity message = BeanMapper.map(logVO, SocketMessageLogEntity.class);
        socketMessageService.saveOrUpdate(message);
        logger.info("保存消息成功！socket消息持久化成功：{}", JSON.toJSONString(message));
        return CommonResponse.success("保存成功！");
    }

    @GetMapping("getSocketMsgLogList")
    @ResponseBody
    CommonResponse<List<SocketMessageLogVO>> getSocketMsgLogList(@RequestParam(value = "userId") Long userId,
                                                                 @RequestParam(value = "sendTime", required = false) String sendTime) {
        List<SocketMessageLogVO> res = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        if (StringUtils.isNotBlank(sendTime)) {
            queryParam.getParams().put("sendTime", new Parameter(QueryParam.LT, sendTime));
        }
        queryParam.getParams().put("userId", Parameter.getEqInstance(userId));
        queryParam.getParams().put("tenantId", Parameter.getEqInstance(InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sendTime", QueryParam.DESC);
        queryParam.setLimit(20);
        List<SocketMessageLogEntity> list = socketMessageService.queryList(queryParam, false);
        if (list != null) {
            res = BeanMapper.mapList(list, SocketMessageLogVO.class);
            res.forEach(item -> {
                if (item.getMsgType().equals(SocketMessageLogVO.ROBOT)) {
                    JSONObject content = JSONObject.parseObject(item.getContent());
                    content.put("msgState", item.getState());
                    item.setContent(JSONObject.toJSONString(content));
                }
            });
        }
        return CommonResponse.success(res);
    }

    @PostMapping("getTokensByUserId")
    @ResponseBody
    public CommonResponse<List<String>> openApp(@RequestBody JSONObject parameter) {
        logger.info("获取用户token：{}", parameter.toJSONString());
        Map<String, String> userSessions = sessionManager.getUserSessionMap(parameter.getLong("userId"));
        List<String> res = new ArrayList<>(userSessions.keySet());
        return CommonResponse.success(res);
    }

}
