package com.ejianc.foundation.message.controller.api;

import com.ejianc.foundation.message.service.IMessageSendService;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;

@RestController
@RequestMapping("/")
public class PushMessageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMessageService messageService;

    @Autowired
    private IMessageSendService messageSendService;


    @PostMapping(value = "api/message/sendUserMsg")
    public CommonResponse<String> sendUserMsg(@RequestBody PushMsgParameter parameter){
        messageSendService.sendUserMsg(parameter);

        return CommonResponse.success("消息发送成功！");
    }

    @PostMapping(value = "api/message/sendMessage")
    public CommonResponse<String> pushMessage(@RequestBody PushMsgParameter parameter) {
        try {
        	if(parameter.getChannel() == null || parameter.getChannel().length == 0) {
        		return CommonResponse.error("消息通道不能为空");
        	}
            if(StringUtils.isBlank(parameter.getMsgType())) {
                return CommonResponse.error("消息类型不能为空");
            }
            if(Arrays.asList(parameter.getChannel()).contains(PushMsgParameter.CHANNEL_TYPE_SYS) || Arrays.asList(parameter.getChannel()).contains(PushMsgParameter.CHANNEL_TYPE_EMAIL)) {
            	if(StringUtils.isBlank(parameter.getSubject()) && StringUtils.isBlank(parameter.getContent())) {
            		return CommonResponse.error("消息标题和消息内容不能同时为空");
            	}
            }
            if(StringUtils.isBlank(parameter.getTenantId())) {
                return CommonResponse.error("租户ID不能为空");
            }
            messageService.sendMessage(parameter);
        } catch (Exception e) {
            logger.info("消息-【{}】发送消息队列异常", e);
            e.printStackTrace();
            return CommonResponse.success("消息发送失败，失败原因：{}", e.getMessage());
        }
        return CommonResponse.success("消息发送成功！");
    }
    
    @PostMapping(value = "no_auth/api/message/sendNoAuthMessage")
    public CommonResponse<String> pushNoAuthMessage(@RequestBody PushMsgParameter parameter) {
        try {
        	if(parameter.getChannel() == null || parameter.getChannel().length == 0) {
        		return CommonResponse.error("消息通道不能为空");
        	}
            if(StringUtils.isBlank(parameter.getMsgType())) {
                return CommonResponse.error("消息类型不能为空");
            }
            if(Arrays.asList(parameter.getChannel()).contains(PushMsgParameter.CHANNEL_TYPE_SYS) || Arrays.asList(parameter.getChannel()).contains(PushMsgParameter.CHANNEL_TYPE_EMAIL)) {
            	if(StringUtils.isBlank(parameter.getSubject()) && StringUtils.isBlank(parameter.getContent())) {
            		return CommonResponse.error("消息标题和消息内容不能同时为空");
            	}
            }
            if(StringUtils.isBlank(parameter.getTenantId())) {
                return CommonResponse.error("租户ID不能为空");
            }
            messageService.sendMessage(parameter);
        } catch (Exception e) {
            logger.info("消息-【{}】发送消息队列异常", e);
            e.printStackTrace();
            return CommonResponse.success("消息发送失败，失败原因：{}", e.getMessage());
        }
        return CommonResponse.success("消息发送成功！");
    }

}
