package com.ejianc.foundation.message.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;

@Service("weixinee")
public class WeixinEEServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(WeixinEEServiceImpl.class);
	
	@Autowired
	private IUserApi userApi;
	@Autowired
	private ITenantApi tenantApi;
	@Autowired
	private IThirdSystemApi thirdSystemApi;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		CommonResponse<TenantVO> tenantResponse = tenantApi.queryDetail(Long.parseLong(pushMsgParameter.getTenantId()));
		String corpid = null;
		boolean thirdApp = false;
		TenantVO tenantVO = null;
		if(tenantResponse.isSuccess()&&tenantResponse.getData()!=null){
			tenantVO = tenantResponse.getData();
			if("wxee".equals(tenantVO.getSourceFrom())){
				thirdApp = true;
				corpid = tenantVO.getCorpid();
				if(StringUtils.isEmpty(tenantVO.getAgentid())){
					CommonResponse<String> response = thirdSystemApi.getWXEEThirdAgentid(corpid);
					if(response.isSuccess()&&response.getData()!=null){
						tenantVO.setAgentid(response.getData());
					}else {
						logger.info("根据企业id查询租户agentid错误，tenantId-{}，corpid-{}", pushMsgParameter.getTenantId(),corpid);
						MsgSendResponse r = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "根据企业id查询租户agentid错误，tenantId- "+pushMsgParameter.getTenantId()+" corpid-"+corpid);
						messageResponseList.add(r);
						return messageResponseList;
					}
				}
			}
		}else {
			logger.info("根据企业id查询租户信息错误，tenantId-{}", pushMsgParameter.getTenantId());
			MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "根据企业id查询租户信息错误，tenantId- "+pushMsgParameter.getTenantId());
			messageResponseList.add(response);
			return messageResponseList;
		}
		if(!thirdApp){
			corpid = configJson.getString("corpid");
		}
		if(StringUtils.isBlank(corpid)) {
			logger.info("根据企业id查询企业微信发送参数错误，corpid-为空{}", corpid);
			MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "根据企业id查询企业微信发送参数异常, corpid-为空"+corpid);
			messageResponseList.add(response);
			return messageResponseList;
		}

		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		JSONObject weixinEEJson = pushMsgParameter.getWeixineeParams();
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			
			String secret = weixinEEJson.getString("secret");
			String agentid = weixinEEJson.getString("agentid");
			if(thirdApp){
				agentid = tenantVO.getAgentid();
			}
			String accessToken = getWeixinCorpAccessToken(corpid, secret, false,thirdApp);
			if(StringUtils.isEmpty(accessToken)){
				logger.info("根据企业id查询企业微信发送参数错误，accessToken-为空{}", corpid);
				MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "根据企业id查询企业微信发送参数异常, accessToken-为空"+corpid);
				messageResponseList.add(response);
				return messageResponseList;
			}
			JSONObject templateJson = new JSONObject();
			templateJson.put("agentid", agentid);
			String msgtype = weixinEEJson.getString("msgtype");
			if(StringUtils.isBlank(msgtype) || "text".equals(msgtype)) {
				String toUser = "";
				for(UserVO userVo:userVos) {
					if(thirdApp){
						toUser = toUser + userVo.getSourceId() + "|";
					}else {
						if(StringUtils.isBlank(userVo.getWeixineeId())){
							logger.info("该用户未绑定企业微信，用户名称【{}】", userVo.getUserName());
							continue;
						}
						toUser = toUser + userVo.getWeixineeId() + "|";
					}

				}
				if(StringUtils.isNotBlank(toUser)) {
					templateJson.put("touser", toUser.substring(0, toUser.length()-1));
				}
				templateJson.put("msgtype", "text");
				templateJson.put("safe", 1); //是否保密发送 0：否， 1：是
				
				JSONObject contentJson = new JSONObject();
				contentJson.put("content", weixinEEJson.getString("content"));
				templateJson.put("text", contentJson);

				String templateContent = JSON.toJSONString(templateJson);
				logger.info("企业微信发送参数： accessToken={}, templateContent={}",accessToken, templateContent);
				String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token="+accessToken, templateContent);
				logger.info("企业微信发送结果：{}",templateResult);
				
				JSONObject httpResult = JSON.parseObject(templateResult);
				if(httpResult != null) {
					logger.info("weixin_response = "+JSON.toJSONString(httpResult));
				}
				if ("ok".equals(httpResult.get("errmsg"))) {
					logger.info("向" + toUser + "发送企业微信成功!");
				} else {
					String invaliduser = httpResult.get("invaliduser").toString();
					if(StringUtils.isNotBlank(invaliduser)) {
						logger.info("企业微信推送成功，部分用户信息推送失败，失败用户Id【{}】", invaliduser);
					} else {
						logger.info("企业微信信息推送成功！");
					}
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "接收人无权限或不存在。");
					messageResponseList.add(response);
				}
			}else if("approve".equals(msgtype)) {
				
				for(UserVO userVo:userVos) {
					String toUser = userVo.getWeixineeId();
					if(thirdApp){
						toUser = userVo.getSourceId();
					}
					if(StringUtils.isBlank(toUser)){
						logger.info("该用户未绑定企业微信，用户名称【{}】", userVo.getUserName());
						continue;
					}
					String content = weixinEEJson.getString("content");
					content = content.replaceAll("%7Buserid%7D", userVo.getId()+"").replaceAll("%7buserid%7d", userVo.getId()+"")
							 .replaceAll("%7BuserId%7D", userVo.getId()+"").replaceAll("%7buserId%7d", userVo.getId()+"")
							 .replaceAll("\\{userid\\}", userVo.getId()+"");
//					if(StringUtils.isNotBlank(toUser)) {
//						templateJson.put("touser", toUser.substring(0, toUser.length()-1));
//					}
					templateJson.put("touser", toUser);
					templateJson.put("msgtype", "text");
					templateJson.put("safe", 0); //是否保密发送 0：否， 1：是
					
					JSONObject contentJson = new JSONObject();
					contentJson.put("content", content);
					templateJson.put("text", contentJson);

					String templateContent = JSON.toJSONString(templateJson);
					logger.info("企业微信发送参数： accessToken={}, templateContent={}",accessToken, templateContent);
					String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token="+accessToken+"&debug=1", templateContent);
					logger.info("企业微信发送结果：{}",templateResult);
					
					JSONObject httpResult = JSON.parseObject(templateResult);
					if(httpResult != null) {
						logger.info("weixin_response = "+JSON.toJSONString(httpResult));
					}
					if ("ok".equals(httpResult.get("errmsg"))) {
						logger.info("向" + toUser + "发送企业微信成功!");
					} else {
						String invaliduser = httpResult.get("invaliduser").toString();
						if(StringUtils.isNotBlank(invaliduser)) {
							logger.info("企业微信推送成功，部分用户信息推送失败，失败用户Id【{}】", invaliduser);
						} else {
							logger.info("企业微信信息推送成功！");
						}
						MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "接收人无权限或不存在。");
						messageResponseList.add(response);
					}
				}
				
			}else if("textcard".equals(msgtype)){
				for(UserVO userVo:userVos) {
					String toUser = userVo.getWeixineeId();
					if(thirdApp){
						toUser = userVo.getSourceId();
					}
					if(StringUtils.isNotBlank(toUser)) {
						templateJson.put("touser", toUser);
					} else {
						logger.info("用户-{}未绑定企业微信！", userVo.getId());
						continue;
					}
					templateJson.put("msgtype", "textcard");
					
					String title = weixinEEJson.getString("title");
					String description = weixinEEJson.getString("description");
					String url = weixinEEJson.getString("url");
					String btntxt = weixinEEJson.getString("btntxt");
					JSONObject textcardJson = new JSONObject();
					textcardJson.put("title", title);
					textcardJson.put("description", description);
					
					url = url.replaceAll("%7Buserid%7D", userVo.getId()+"").replaceAll("%7buserid%7d", userVo.getId()+"")
							 .replaceAll("%7BuserId%7D", userVo.getId()+"").replaceAll("%7buserId%7d", userVo.getId()+"")
							 .replaceAll("\\{userid\\}", userVo.getId()+"");
					textcardJson.put("url", url);
					if(StringUtils.isNotBlank(btntxt)) {
						textcardJson.put("btntxt", btntxt);
					}else{
						textcardJson.put("btntxt", "点击查看");
					}
					templateJson.put("textcard", textcardJson);
					
					String templateContent = JSON.toJSONString(templateJson);
					logger.info("企业微信发送参数： accessToken={}, templateContent={}",accessToken, templateContent);
					String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token="+accessToken, templateContent);
					logger.info("企业微信发送结果：{}",templateResult);
					
					JSONObject httpResult = JSON.parseObject(templateResult);
					if(httpResult != null) {
						logger.info("weixin_response = "+JSON.toJSONString(httpResult));
					}
					if ("ok".equals(httpResult.get("errmsg"))) {
						logger.info("向" + toUser + "发送企业微信成功!");
					} else {
						String invaliduser = httpResult.getString("invaliduser");
						if(StringUtils.isNotBlank(invaliduser)) {
							logger.info("企业微信推送成功，部分用户信息推送失败，失败用户Id【{}】", invaliduser);
						} else {
							logger.info("企业微信信息推送成功！");
						}

						if("40001".equals(httpResult.getString("errcode"))) {
							//该问题可能是access_token过期导致，清除redis中缓存的access_token
							getWeixinCorpAccessToken(corpid, secret, true,thirdApp);
						}
						MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "接收人无权限或不存在。");
						messageResponseList.add(response);
					}
				}
			}else if("news".equals(msgtype)){
				for(UserVO userVo:userVos) {
					String toUser = userVo.getWeixineeId();
					if(thirdApp){
						toUser = userVo.getSourceId();
					}
					if(StringUtils.isBlank(toUser)){
						logger.info("该用户未绑定企业微信，用户名称【{}】", userVo.getUserName());
						continue;
					}
					templateJson.put("touser", toUser);
					templateJson.put("msgtype", "news");
					
					String title = weixinEEJson.getString("title");
					String description = weixinEEJson.getString("description");
					String url = weixinEEJson.getString("url");
					String btntxt = weixinEEJson.getString("btntxt");
					JSONObject newsJson = new JSONObject();
					
					List<JSONObject> articles = new ArrayList<>();
					JSONObject article = new JSONObject();
					article.put("title", title);
					article.put("description", description);
//					article.put("articles", title);
					url = url.replaceAll("%7Buserid%7D", userVo.getId()+"").replaceAll("%7buserid%7d", userVo.getId()+"")
							 .replaceAll("%7BuserId%7D", userVo.getId()+"").replaceAll("%7buserId%7d", userVo.getId()+"")
							 .replaceAll("\\{userid\\}", userVo.getId()+"");
					article.put("url", url);

					articles.add(article);
					articles.add(article);
					newsJson.put("articles", articles);
//					newsJson.put("url", url);

//					textcardJson.put("picurl", "http://res.mail.qq.com/node/ww/wwopenmng/images/independent/doc/test_pic_msg1.png");
//					textcardJson.put("content", weixinEEJson.getString("content"));
					templateJson.put("news", newsJson);
					
					String templateContent = JSON.toJSONString(templateJson);
					logger.info("企业微信发送参数： accessToken={}, templateContent={}",accessToken, templateContent);
					String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token="+accessToken, templateContent);
					logger.info("企业微信发送结果：{}",templateResult);
					
					JSONObject httpResult = JSON.parseObject(templateResult);
					if(httpResult != null) {
						logger.info("weixin_response = "+JSON.toJSONString(httpResult));
					}
					if ("ok".equals(httpResult.get("errmsg"))) {
						logger.info("向" + toUser + "发送企业微信成功!");
					} else {
						String invaliduser = httpResult.getString("invaliduser");
						if(StringUtils.isNotBlank(invaliduser)) {
							logger.info("企业微信推送成功，部分用户信息推送失败，失败用户Id【{}】", invaliduser);
						} else {
							logger.info("企业微信信息推送成功！");
						}

						if("40001".equals(httpResult.getString("errcode"))) {
							//该问题可能是access_token过期导致，清除redis中缓存的access_token
							getWeixinCorpAccessToken(corpid, secret, true,thirdApp);
						}
						MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "接收人无权限或不存在。");
						messageResponseList.add(response);
					}
				}
			}else if("templatecard".equals(msgtype)){
				for(UserVO userVo:userVos) {
					String toUser = userVo.getWeixineeId();
					if(thirdApp){
						toUser = userVo.getSourceId();
					}
					if(StringUtils.isBlank(toUser)){
						logger.info("该用户未绑定企业微信，用户名称【{}】", userVo.getUserName());
						continue;
					}
					if(StringUtils.isNotBlank(toUser)) {
						templateJson.put("touser", toUser);
					}
					templateJson.put("msgtype", "template_card");
					
					String title = weixinEEJson.getString("title");
					String description = weixinEEJson.getString("description");
					String url = weixinEEJson.getString("url");
					String btntxt = weixinEEJson.getString("btntxt");
					
					JSONObject textcardJson = new JSONObject();
					textcardJson.put("card_type", "text_notice");
					
					JSONObject source = new JSONObject();
					source.put("desc", title+"source");
					textcardJson.put("source", source);
					
					JSONObject mainTitle = new JSONObject();
					mainTitle.put("title", title);
					textcardJson.put("main_title", mainTitle);
					
					textcardJson.put("sub_title_text", description);
					
//					JSONObject content = new JSONObject();
//					content.put("title", description+"emphasis_content");
//					textcardJson.put("emphasis_content", content);

					JSONObject cardaction = new JSONObject();
					cardaction.put("type", 1);
					url = url.replaceAll("%7Buserid%7D", userVo.getId()+"").replaceAll("%7buserid%7d", userVo.getId()+"")
							 .replaceAll("%7BuserId%7D", userVo.getId()+"").replaceAll("%7buserId%7d", userVo.getId()+"")
							 .replaceAll("\\{userid\\}", userVo.getId()+"");
					
					cardaction.put("url", url);
					textcardJson.put("card_action", cardaction);
//					textcardJson.put("url", url);
//					if(StringUtils.isNotBlank(btntxt)) {
//						textcardJson.put("btntxt", btntxt);
//					}else{
//						textcardJson.put("btntxt", "点击查看");
//					}
					textcardJson.put("title", weixinEEJson.getString("content"));
					textcardJson.put("content", weixinEEJson.getString("content"));
					templateJson.put("template_card", textcardJson);
					
					String templateContent = JSON.toJSONString(templateJson);
					logger.info("企业微信发送参数： accessToken={}, templateContent={}",accessToken, templateContent);
					String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token="+accessToken, templateContent);
					logger.info("企业微信发送结果：{}",templateResult);
					
					JSONObject httpResult = JSON.parseObject(templateResult);
					if(httpResult != null) {
						logger.info("weixin_response = "+JSON.toJSONString(httpResult));
					}
					if ("ok".equals(httpResult.get("errmsg"))) {
						logger.info("向" + toUser + "发送企业微信成功!");
					} else {
						String invaliduser = httpResult.getString("invaliduser");
						if(StringUtils.isNotBlank(invaliduser)) {
							logger.info("企业微信推送成功，部分用户信息推送失败，失败用户Id【{}】", invaliduser);
						} else {
							logger.info("企业微信信息推送成功！");
						}

						if("40001".equals(httpResult.getString("errcode"))) {
							//该问题可能是access_token过期导致，清除redis中缓存的access_token
							getWeixinCorpAccessToken(corpid, secret, true,thirdApp);
						}
						MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "接收人无权限或不存在。");
						messageResponseList.add(response);
					}
				}
			}
		}
		return messageResponseList;
	}
	
	public String getWeixinCorpAccessToken(String corpAppId, String corpSecret, boolean reload,boolean thirdApp) {
		if(thirdApp){
			CommonResponse<String> response = thirdSystemApi.getWXEEThirdAppAccessToken(corpAppId);
			if(response.isSuccess()){
				return response.getData();
			}else {
				return null;
			}
		}
		String key = corpAppId+"_"+corpSecret;
		String accessToken = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----accessToken="+accessToken);
//		System.out.println("redis----accessToken="+accessToken);
		if(StringUtils.isBlank(accessToken) || reload) {
			logger.info("获取企业微信accessToken参数----corpid：{},corpsecret:{}=",corpAppId,corpSecret);
			String accessResult = null;
			if("ww9a1aec7b32791088".equals(corpAppId)){
				accessResult = WeixinRestUtil.doGetByURL("https://ihj.cnecc.com/cgi-bin/gettoken?corpid="+corpAppId+"&corpsecret="+corpSecret, null);
			}else{
				accessResult = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid="+corpAppId+"&corpsecret="+corpSecret, null);
			}
			logger.info("accessResult="+accessResult);
//			System.out.println("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				accessToken = accessJson.getString("access_token");
				if(StringUtils.isNotBlank(accessToken)) {
					redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return accessToken;
	}


	public static void main(String[] arguments){

		JSONObject templateJson = new JSONObject();
		String corpid = "ww2dd60a57572d9031";
		String agentid = "1000009";//轻量化平台数据
		String secret = "--H9WQNM_7IsSSmVhmHC3SCIMB_RkGv979u1pIUaS3s";
		logger.info("获取企业微信accessToken参数----corpid：{},corpsecret:{}=");
		String accessResult = WeixinRestUtil.doGetByURL("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid="+corpid+"&corpsecret="+secret, null);
		String accessToken = null;
		if(StringUtils.isNotBlank(accessResult)) {
			JSONObject accessJson = JSON.parseObject(accessResult);
			accessToken = accessJson.getString("access_token");
		}

		logger.info("获取企业微信accessToken参数----{}",accessToken);
		templateJson.put("agentid", agentid);
		String toUser = "MuYan";
		templateJson.put("touser", toUser);
		/*
		templateJson.put("msgtype", "template_card");
		String title = "卡片消息测试1";
		String description = "卡片消息测试1内容";
		String url = "https://dev.17elian.com";
		JSONObject textcardJson = new JSONObject();
		textcardJson.put("card_type", "text_notice");
		JSONObject source = new JSONObject();
		source.put("desc", title+"source");
		textcardJson.put("source", source);
		JSONObject mainTitle = new JSONObject();
		mainTitle.put("title", title);
		textcardJson.put("main_title", mainTitle);
		textcardJson.put("sub_title_text", description);
		JSONObject cardaction = new JSONObject();
		cardaction.put("type", 1);
		cardaction.put("url", url);
		textcardJson.put("card_action", cardaction);
		textcardJson.put("title", title);
		textcardJson.put("content", description);
		templateJson.put("template_card", textcardJson);
*/
		/*
		String title = "文本消息测试1";
		String description = "文本消息测试1内容";
		templateJson.put("msgtype", "text");
		templateJson.put("safe", 0); //是否保密发送 0：否， 1：是
		JSONObject contentJson = new JSONObject();
		contentJson.put("content", description);
		templateJson.put("text", contentJson);
		*/

		String title = "文本消息测试标题1";
		String description = "<div>文本消息测试1内容</div>";
		templateJson.put("msgtype", "textcard");
		templateJson.put("safe", 0); //是否保密发送 0：否， 1：是
		JSONObject contentJson = new JSONObject();
		contentJson.put("title", title);
		contentJson.put("description", description);
		contentJson.put("url",  "https://www.baidu.com/");
		templateJson.put("textcard", contentJson);


		String templateContent = JSON.toJSONString(templateJson);
		logger.info("企业微信发送参数： accessToken={}, templateContent={}",accessToken, templateContent);
		String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token="+accessToken, templateContent);
		logger.info("企业微信发送结果：{}",templateResult);

	}
}
