package com.ejianc.foundation.message.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;

@Service("weixinminprogram")
public class WeixinMinProgramServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(WeixinMinProgramServiceImpl.class);
	
	@Autowired
	private IUserApi userApi;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		String appid = configJson.getString("appid");
		String appsecret = configJson.getString("appsecret");
		
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		if(StringUtils.isBlank(appid) || StringUtils.isBlank(appsecret)) {
			logger.info("获取微信小程序参数为空，appid-{},appsecret-{}", appid, appsecret);
			MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "获取微信小程序参数为空,agentid-"+appid+",appsecret-"+appsecret);
			messageResponseList.add(response);
			return messageResponseList;
		}
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			
			String accessToken = getWeixinMinProgramAccessToken(appid, appsecret, false);
			JSONObject minProgramJson = pushMsgParameter.getWeixinMinProgramParams();
			for(UserVO userVo : userVos) {
				if(StringUtils.isBlank(userVo.getWeixinMinprogramId())) {
					continue;
				}
				JSONObject templateJson = new JSONObject();
				templateJson.put("touser", userVo.getWeixinMinprogramId());
				templateJson.put("template_id", minProgramJson.getString("template_id"));
				
				String page = minProgramJson.getString("page");
				if(StringUtils.isNotBlank(page)) {
					templateJson.put("page", page);
				}
				
				JSONObject wxparams = minProgramJson.getJSONObject("data");
				if(wxparams != null && !wxparams.isEmpty()) {
					JSONObject wxparamJson = new JSONObject();
					for(String key:wxparams.keySet()) {
						JSONObject keyJson = new JSONObject();
						keyJson.put("value", wxparams.get(key));
						wxparamJson.put(key, keyJson);
					}
					templateJson.put("data", wxparamJson);
				}
				
				String miniprogramState = minProgramJson.getString("miniprogram_state");
				if(StringUtils.isNotBlank(miniprogramState)) {
					templateJson.put("miniprogram_state", miniprogramState);
				}
				templateJson.put("lang", "zh_CN");
				
				String templateContent = JSON.toJSONString(templateJson);
				logger.info("微信小程序发送信息,{}",templateContent);
				
				String templateResult = WeixinRestUtil.doPostByURL("https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token="+accessToken, templateContent);
				JSONObject httpResult = JSON.parseObject(templateResult);
				if(httpResult != null) {
					logger.info("weixin_response = "+JSON.toJSONString(httpResult));
				}
				if ("ok".equals(httpResult.get("errmsg"))) {
					logger.info("向" + userVo.getWeixinId() + "发送微信小程序成功!");
				} else {
					if("40001".equals(httpResult.getString("errcode"))) {
						//该问题可能是access_token过期导致，清除redis中缓存的access_token
						getWeixinMinProgramAccessToken(appid, appsecret, true);
					}
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "微信小程序模板消息发送失败", userVo.getWeixinId());
					logger.info("向" + userVo.getWeixinId() + "发送微信小程序失败!");
					messageResponseList.add(response);
				}
			}
		}
		return messageResponseList;
	}

	private String getWeixinMinProgramAccessToken(String appid, String appsecret, boolean reload) {
		String key = appid+"_"+appsecret;
		String accessToken = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----accessToken="+accessToken);
		System.out.println("redis----accessToken="+accessToken);
		if(StringUtils.isBlank(accessToken) || reload) {
			String accessResult = WeixinRestUtil.doGetByURL("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid="+appid+"&secret="+appsecret, null);
			logger.info("accessResult="+accessResult);
			System.out.println("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				accessToken = accessJson.getString("access_token");
				if(StringUtils.isNotBlank(accessToken)) {
					redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return accessToken;
	}

}
