package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service("zdsSupEmail")
public class ZdsSupEmailServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(ZdsSupEmailServiceImpl.class);

	@Autowired
	private IUserApi userApi;

	@Value("${ejc.sms.zds.sup.elhost:0}")
	private String ElHost;
	@Value("${ejc.sms.zds.sup.elappid:0}")
	private String ElAppId;
	@Value("${ejc.sms.zds.sup.elsecret:0}")
	private String ElSecret;

	@Autowired
	private ISystemDataPushService systemDataPushService;

	private final String EL_EMAIL_URL = "/ejc-message-web/openapi/api/message/sendUserMsg";

	/**
	 * 调用项目方发送邮件接口 向指定人员发送邮件
	 *
	 * @param configInfo
	 * @param pushMsgParameter 消息参数
	 * @return
	 */
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		List<String> userEmail = new ArrayList<>();
		List<String> userName = new ArrayList<>();

		if(null != pushMsgParameter.getReceivers() && pushMsgParameter.getReceivers().length > 0) {
			CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),
					Long.parseLong(pushMsgParameter.getTenantId()));
			if(userResponse.isSuccess()) {
				List<UserVO> userVos = userResponse.getData();

				if(userVos.size() > 0) {
					for(UserVO userVo:userVos) {
						if(StringUtils.isNotBlank(userVo.getUserEmail())) {
							userEmail.add(userVo.getUserEmail());
							userName.add(userVo.getUserName());
						}else{
							logger.info("向人员【{}】发送邮件失败，人员邮箱为空",userVo.getUserName());
							MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "向人员【"+userVo.getUserName()+"】发送邮件失败，人员邮箱为空");
							messageResponseList.add(response);
						}
					}
				}
			}
		} else if(null != pushMsgParameter.getZdsExtEmailParams() && null != pushMsgParameter.getZdsExtEmailParams().getString("userEmails")) {
			String[] userEmailsArr = pushMsgParameter.getZdsExtEmailParams().getString("userEmails").split(",");
			String[] userNameArr = pushMsgParameter.getZdsExtEmailParams().getString("userNames").split(",");
			if(userEmailsArr.length != userNameArr.length) {
				logger.error("中电四发送邮件失败，接收人邮箱列表【{}】与接收人名称【{}】不匹配!",
						pushMsgParameter.getZdsExtEmailParams().getString("userEmails"), pushMsgParameter.getZdsExtEmailParams().getString("userNames"));
				throw new BusinessException("中电四发送邮件失败，接收人邮箱列表与接收人名称不匹配!");
			}
			userEmail.addAll(Arrays.asList(userEmailsArr));
			userName.addAll(Arrays.asList(userNameArr));
		}

		if(CollectionUtils.isEmpty(userEmail)) {
			return messageResponseList;
		}
		PushMsgParameter sendParam = JSONObject.parseObject(JSONObject.toJSONString(pushMsgParameter), PushMsgParameter.class);
		pushMsgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL});
		sendParam.setReceivers(null);
		sendParam.getZdsExtEmailParams().put("userEmails", StringUtils.join(userEmail, ","));
		sendParam.getZdsExtEmailParams().put("userNames", StringUtils.join(userName, ","));

		CommonResponse<String> emailSendResult = systemDataPushService.exchangeDataWithUniversal(EL_EMAIL_URL,
				RequestMethod.POST, JSONObject.toJSONString(sendParam), ElAppId, ElSecret, ElHost);
		logger.info("调用EL平台邮件发送参数: param={} ElAppId={},ElSecret-{},ElHost-{}",JSONObject.toJSONString(sendParam),
				ElAppId, ElSecret, ElHost);

		if(!emailSendResult.isSuccess()) {
			logger.error("调用EL平台进行邮件发送失败，{}", JSONObject.toJSONString(emailSendResult));
			MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "向人员【"+StringUtils.join(userName, ",")+"】发送邮件失败！");
			messageResponseList.add(response);
			return messageResponseList;
		}
		CommonResponse<List<MsgSendResponse>> msgSendResult = JSONObject.parseObject(emailSendResult.getData(), CommonResponse.class);
		messageResponseList.addAll(msgSendResult.getData());

		return messageResponseList;
	}
}
