package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.HttpTookit;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

@Service("zhiyuanoa")
public class ZhiyuanoaServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(ZhiyuanoaServiceImpl.class);

	private Gson gson = new Gson();
	@Autowired
	private IUserApi userApi;
	@Autowired
	private EnvironmentTools environmentTools;
	
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		String oaUrl = configJson.getString("oaUrl");
		String registerCode = configJson.getString("registerCode");
		String tokenUserName = configJson.getString("tokenUserName");
		String tokenPassword = configJson.getString("tokenPassword");

		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			for(UserVO userVo:userVos) {
				try {
					logger.info("调用致远oa 接口：发送消息接口start------------------");
					String serverUrl = oaUrl + "/seeyon/rest/thirdpartyMessage/receive/singleMessage";
					String maurl = pushMsgParameter.getMobileUrl();
					String pcurl = pushMsgParameter.getPcUrl();
					if(!maurl.startsWith("http")){
						if(maurl.startsWith("/")){
							maurl = (environmentTools.getBaseHost().substring(0,environmentTools.getBaseHost().length()-1)) + maurl;
						}else{
							maurl = (environmentTools.getBaseHost()) + maurl;
						}
					}
					if(!pcurl.startsWith("http")){
						if(pcurl.startsWith("/")){
							pcurl = (environmentTools.getBaseHost().substring(0,environmentTools.getBaseHost().length()-1)) + pcurl;
						}else{
							pcurl = (environmentTools.getBaseHost()) + pcurl;
						}
					}
					String content = pushMsgParameter.getContent();
					content = content.replace(("<a href="+'"'+pcurl+'"'+">前往点击</a>"), "");
					content = content.replace(("<a href="+'"'+pcurl+'"'+">点击查看</a>"), "");
					maurl = this.dealUrl(maurl, userVo);
					String jumpUrl = environmentTools.getBaseHost() + "portal/julisso/login?targetUrl=";
					//modelId格式：单据id-用户编码-taskId
					/*
						thirdpartyMessageId	是	第三方消息主键（保证唯一）
						thirdpartyRegisterCode	是		为第三方配置的系统注册编码
						messageContent	是	消息内容  长度（VARCHAR(4000)）
						thirdpartySenderId	否	第三方消息发起人主键（保证唯一）
						thirdpartyReceiverId	是	第三方消息接收人主键（保证唯一）
						creation_date	是	消息创建时间（格式：yyyy-MM-dd HH:mm:ss）
						downloadUrl	否	原生应用下载地址（仅选则原生类型后提供），移动端没有安装程序跳转到此地址
						messageURL	否	PC端穿透链接
						messageH5URL	否	移动端穿透链接
						appParam	否	原生应用穿透命令，穿透命令需要按这个顺序：iphone\
					*/
					SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					Map<String, String> paramterMap = new HashMap<>();
					paramterMap.put("thirdpartyMessageId", String.valueOf(IdWorker.getId()));
					paramterMap.put("thirdpartyRegisterCode", registerCode);
					paramterMap.put("messageContent", content);
					paramterMap.put("thirdpartySenderId", userVo.getUserCode());
					paramterMap.put("noneBindingSender", userVo.getUserCode());
					paramterMap.put("thirdpartyReceiverId", userVo.getUserCode());
					paramterMap.put("noneBindingReceiver", userVo.getUserCode());
					paramterMap.put("creation_date", formatter.format(new Date()));
					paramterMap.put("messageURL", jumpUrl + URLEncoder.encode(pcurl,"utf-8"));
					paramterMap.put("messageH5URL", maurl);

					logger.info("发送消息传递的参数：---------------"+paramterMap.toString());
					String paramterStr = gson.toJson(paramterMap);
					String token = this.getToken(oaUrl, tokenUserName, tokenPassword);
					Map<String, String> header = new HashMap<>();
					header.put("token", token);
					String result = HttpTookit.postByJson(serverUrl, paramterStr, header);
					logger.info("发送致远oa消息返回结果：---------》》》》"+result);
				} catch (Exception e) {
					e.printStackTrace();
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "致远oa消息发送失败", userVo.getUserCode());
					logger.info("向" + userVo.getUserCode() + "发送致远oa失败!");
					messageResponseList.add(response);
				}
				
			}
		}
		return messageResponseList;
	}

	public String getToken(String oaUrl, String tokenUserName, String tokenPassword){
		String token = null;
		String serverUrl = oaUrl + "/seeyon/rest/token";
		try {
			logger.info("获取token开始----------------");
			Map<String, String> paramterMap = new HashMap<>();
			paramterMap.put("userName", tokenUserName);
			paramterMap.put("password", tokenPassword);
			String paramterStr = gson.toJson(paramterMap);
			logger.info("serverUrl---------》"+serverUrl);
			logger.info("参数---------》"+paramterStr);
			String result = HttpTookit.postByJson(serverUrl, paramterStr);
			logger.info(result);
			JSONObject json = JSONObject.parseObject(result);
			if(json.getString("id")!=null&&!"-1".equals(json.getString("id"))){
				token = json.getString("id");
			}
			logger.info("获取token结束----------------");
		} catch (Exception e) {
			logger.info("获取青岛市政token失败----"+e.getMessage());
			throw new BusinessException("获取青岛市政token失败----");
		}
		return token;
	}


	public String dealUrl(String url, UserVO userVo) {
		if (url.contains("userid")) {
			url = url.replaceAll("%7Buserid%7D", userVo.getId().toString()).replaceAll("%7buserid%7d", userVo.getId().toString()).replaceAll("\\{userid\\}", userVo.getId().toString());
		} else {
			if (url.contains("?")) {
				url += ("&userid=" + userVo.getId().toString());
			} else {
				url += ("?userid=" + userVo.getId().toString());
			}
		}
		return url;
	}
}
