package com.ejianc.foundation.message.service.impl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.foundation.message.util.ZZYJMD5;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

@Service
public class ZzyjSmsServiceImpl implements ISmsService {
	private static final Logger logger = LoggerFactory.getLogger(ZzyjSmsServiceImpl.class);
	
	@Autowired
	private JedisTemplate jedis;
	
	@Override
	public CommonResponse<String> sendMessage(SmsMessageParam param) {
		logger.debug("发送短信参数：{}", param.toString());
		try {
			if(!Validate.isMobile(param.getPhone())) {
				throw new BusinessException("手机号不合法！");
			}

	        try {
	        	Map<String, String> params = param.getParams();
	        	
	        	StringBuffer sb = new StringBuffer("http://sdk.lx198.com/sdk/send?");
	        	String rand = ProduceNumber.produce();
	        	String content = null;
	        	
	        	if("SMS_273725524".equals(param.getTemplateCode())) {
	        		String userName = params.get("userName");
	        		String publishTime = params.get("publishTime");
	        		String title = params.get("title");
	        		String amount = params.get("amount");
					content = "尊敬的"+userName+"，您在"+publishTime+"的针对"+title+"的投标报价已中标，中标金额："+amount+"元，可联系客户方负责人了解中标详情！ 【郑州一建】";
				}else if("SMS_250340068".equals(param.getTemplateCode())) {
					String userCode = params.get("userCode");
					String userPassword = params.get("userPassword");
					content = "您已成为郑州一建集团有限公司的供应商，请在电脑端访问网址（https://xt.zzyjjt.com）办理业务，也可以手机端关注微信公众号[郑州一建云协同]办理业务。账号:"+userCode+"，默认初始密码:"+userPassword+" 【郑州一建】";
				}else if("SMS_242697630".equals(param.getTemplateCode())) {
					String publishTime = params.get("publishTime");
					content = "尊敬的郑州一建集团有限公司的合作商，感谢您长期以来的友好合作，我公司将于"+publishTime+"全面上线数字化系统招标管理、合同管理，所有招标采购、合同签定均实现线上化、无纸化，期待贵公司的积极参与和配合，关注\"郑州一建云协同\"微信公众号或登陆\"https://xt.zzyjjt.com/\"云协同平台，了解我公司更多业务。 【郑州一建】";
				}else{
					content = "验证码："+rand+"（郑州一建客服绝对不会索要验证码，切勿告诉他人）,感谢您的支持。 【郑州一建】";
				}

				sb.append("&AppID=zQVVYM8M");
				sb.append("&AppSecret=547998c157ed89b13e9ad9c52d3c580b8b5cc26d");
				sb.append("&aimcodes=").append(param.getPhone());
				sb.append("&content=").append(URLEncoder.encode(content, "UTF-8")); //中文做encode转换

	            URL url = new URL(sb.toString());
	            System.out.println("发送短信url："+url);
	            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
	            connection.setRequestMethod("POST");
	            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
	            
	            String resultStr = in.readLine();
	            
	            System.out.println(resultStr);
	            if(StringUtils.isNotBlank(resultStr) && resultStr.indexOf("发送成功") != -1) {
	            	jedis.setex(param.getTemplateCode()+param.getPhone(), rand, 600);
            		
            		return CommonResponse.success("短信发送成功");
	            }
	        } catch (Exception e) {
	        	logger.error(e.getMessage());
	            e.printStackTrace();
	        } 
		} catch(Exception e) {
			logger.error(e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("短信发送失败");
	}

}
