package com.ejianc.foundation.message.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;

import cn.hutool.http.HttpRequest;


/**
 * <p>Title:SmsUtils </p>
 * <p>Description: </p>
 * <p>Company: </p>
 */
public class SmsUtils {
	private static final Logger logger = LoggerFactory.getLogger(SmsUtils.class);

    private static final String URL = "http://www.dh3t.com/json/sms/Submit";
    private static final String ACCOUNT = "3605079";
    private static final String PASSWORD = "3JeKahEA";
	public static void main(String[] args) {
		List<String> phones = new ArrayList<>();
		phones.add("13120319591");
        String responseStr = sendMsg("【水电八局】", phones, "验证码：996655（水电八局客服绝对不会索要验证码，切勿告诉他人）,感谢您的支持!");
        logger.info("短信下发请求结果：{}" ,responseStr);
	}
    /***
     * 下发短信
     * @param signText 签名
     * @param phones  单条时为单个号码，多条时号码以,分隔
     * @param content 短信内容，根据模板填充响应，已,分割
     */
    public static String sendMsg(String signText, List<String> phones, String content) {
        JSONObject result = new JSONObject();
        result.put("resultcode","1");
        try {
            JSONObject param = new JSONObject();
            param.put("account", ACCOUNT);
            param.put("password", encrypt32(PASSWORD));
            param.put("phones", String.join(",", phones));
            param.put("content", content);
            param.put("sign", signText);


            String res = HttpRequest.post(URL)
                    .body(param.toJSONString())
                    .timeout(20 * 1000)
                    .execute().body();
            logger.info("短信下发请求参数：{}  请求结果：{}" ,param, res);
            if(res!=null){
                result.put("resultcode",JSON.parseObject(res).getString("result"));
            }
        } catch (Exception ex) {
        	logger.error("下发短信出现异常！", ex);
        }
        return result.toJSONString();
    }

    /**
     * 加密字符串为32位小写MD5值
     *
     * @param input 需要加密的字符串
     * @return MD5加密后的32位小写字符串
     */
    public static String encrypt32(String input) {
        try {
            // 获取MD5实例
            MessageDigest md = MessageDigest.getInstance("MD5");
            // 更新输入字符串的字节
            byte[] hashBytes = md.digest(input.getBytes());

            // 将字节数组转换为32位小写十六进制字符串
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                hexString.append(String.format("%02x", 0xFF & b));
            }

            return hexString.toString().toLowerCase();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found", e);
        }
    }


}
