/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.controller.api;

import com.ejianc.foundation.message.service.IMessageSendService;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PushMessageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMessageService messageService;
    @Autowired
    private IMessageSendService messageSendService;

    @PostMapping(value={"api/message/sendUserMsg"})
    public CommonResponse<String> sendUserMsg(@RequestBody PushMsgParameter parameter) {
        this.messageSendService.sendUserMsg(parameter);
        return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
    }

    @PostMapping(value={"api/message/sendMessage"})
    public CommonResponse<String> pushMessage(@RequestBody PushMsgParameter parameter) {
        try {
            if (parameter.getChannel() == null || parameter.getChannel().length == 0) {
                return CommonResponse.error((String)"\u6d88\u606f\u901a\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)parameter.getMsgType())) {
                return CommonResponse.error((String)"\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((Arrays.asList(parameter.getChannel()).contains("sys") || Arrays.asList(parameter.getChannel()).contains("email")) && StringUtils.isBlank((CharSequence)parameter.getSubject()) && StringUtils.isBlank((CharSequence)parameter.getContent())) {
                return CommonResponse.error((String)"\u6d88\u606f\u6807\u9898\u548c\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)parameter.getTenantId())) {
                return CommonResponse.error((String)"\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.messageService.sendMessage(parameter);
        }
        catch (Exception e) {
            this.logger.info("\u6d88\u606f-\u3010{}\u3011\u53d1\u9001\u6d88\u606f\u961f\u5217\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
    }

    @PostMapping(value={"no_auth/api/message/sendNoAuthMessage"})
    public CommonResponse<String> pushNoAuthMessage(@RequestBody PushMsgParameter parameter) {
        try {
            if (parameter.getChannel() == null || parameter.getChannel().length == 0) {
                return CommonResponse.error((String)"\u6d88\u606f\u901a\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)parameter.getMsgType())) {
                return CommonResponse.error((String)"\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((Arrays.asList(parameter.getChannel()).contains("sys") || Arrays.asList(parameter.getChannel()).contains("email")) && StringUtils.isBlank((CharSequence)parameter.getSubject()) && StringUtils.isBlank((CharSequence)parameter.getContent())) {
                return CommonResponse.error((String)"\u6d88\u606f\u6807\u9898\u548c\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)parameter.getTenantId())) {
                return CommonResponse.error((String)"\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.messageService.sendMessage(parameter);
        }
        catch (Exception e) {
            this.logger.info("\u6d88\u606f-\u3010{}\u3011\u53d1\u9001\u6d88\u606f\u961f\u5217\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
    }
}

