/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="zdsSupEmail")
public class ZdsSupEmailServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(ZdsSupEmailServiceImpl.class);
    @Autowired
    private IUserApi userApi;
    @Value(value="${ejc.sms.zds.sup.elhost:0}")
    private String ElHost;
    @Value(value="${ejc.sms.zds.sup.elappid:0}")
    private String ElAppId;
    @Value(value="${ejc.sms.zds.sup.elsecret:0}")
    private String ElSecret;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String EL_EMAIL_URL = "/ejc-message-web/openapi/api/message/sendUserMsg";

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        ArrayList<String> userEmail = new ArrayList<String>();
        ArrayList<String> userName = new ArrayList<String>();
        if (null != pushMsgParameter.getReceivers() && pushMsgParameter.getReceivers().length > 0) {
            List userVos;
            CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
            if (userResponse.isSuccess() && (userVos = (List)userResponse.getData()).size() > 0) {
                for (UserVO userVo : userVos) {
                    if (StringUtils.isNotBlank((CharSequence)userVo.getUserEmail())) {
                        userEmail.add(userVo.getUserEmail());
                        userName.add(userVo.getUserName());
                        continue;
                    }
                    logger.info("\u5411\u4eba\u5458\u3010{}\u3011\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u4eba\u5458\u90ae\u7bb1\u4e3a\u7a7a", (Object)userVo.getUserName());
                    MsgSendResponse response = new MsgSendResponse("0", "\u5411\u4eba\u5458\u3010" + userVo.getUserName() + "\u3011\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u4eba\u5458\u90ae\u7bb1\u4e3a\u7a7a");
                    messageResponseList.add(response);
                }
            }
        } else if (null != pushMsgParameter.getZdsExtEmailParams() && null != pushMsgParameter.getZdsExtEmailParams().getString("userEmails")) {
            String[] userNameArr;
            String[] userEmailsArr = pushMsgParameter.getZdsExtEmailParams().getString("userEmails").split(",");
            if (userEmailsArr.length != (userNameArr = pushMsgParameter.getZdsExtEmailParams().getString("userNames").split(",")).length) {
                logger.error("\u4e2d\u7535\u56db\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u63a5\u6536\u4eba\u90ae\u7bb1\u5217\u8868\u3010{}\u3011\u4e0e\u63a5\u6536\u4eba\u540d\u79f0\u3010{}\u3011\u4e0d\u5339\u914d!", (Object)pushMsgParameter.getZdsExtEmailParams().getString("userEmails"), (Object)pushMsgParameter.getZdsExtEmailParams().getString("userNames"));
                throw new BusinessException("\u4e2d\u7535\u56db\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u63a5\u6536\u4eba\u90ae\u7bb1\u5217\u8868\u4e0e\u63a5\u6536\u4eba\u540d\u79f0\u4e0d\u5339\u914d!");
            }
            userEmail.addAll(Arrays.asList(userEmailsArr));
            userName.addAll(Arrays.asList(userNameArr));
        }
        if (CollectionUtils.isEmpty(userEmail)) {
            return messageResponseList;
        }
        PushMsgParameter sendParam = (PushMsgParameter)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pushMsgParameter), PushMsgParameter.class);
        pushMsgParameter.setChannel(new String[]{"email"});
        sendParam.setReceivers(null);
        sendParam.getZdsExtEmailParams().put("userEmails", (Object)StringUtils.join(userEmail, (String)","));
        sendParam.getZdsExtEmailParams().put("userNames", (Object)StringUtils.join(userName, (String)","));
        CommonResponse emailSendResult = this.systemDataPushService.exchangeDataWithUniversal("/ejc-message-web/openapi/api/message/sendUserMsg", RequestMethod.POST, JSONObject.toJSONString((Object)sendParam), this.ElAppId, this.ElSecret, this.ElHost);
        logger.info("\u8c03\u7528EL\u5e73\u53f0\u90ae\u4ef6\u53d1\u9001\u53c2\u6570: param={} ElAppId={},ElSecret-{},ElHost-{}", new Object[]{JSONObject.toJSONString((Object)sendParam), this.ElAppId, this.ElSecret, this.ElHost});
        if (!emailSendResult.isSuccess()) {
            logger.error("\u8c03\u7528EL\u5e73\u53f0\u8fdb\u884c\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)emailSendResult));
            MsgSendResponse response = new MsgSendResponse("0", "\u5411\u4eba\u5458\u3010" + StringUtils.join(userName, (String)",") + "\u3011\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff01");
            messageResponseList.add(response);
            return messageResponseList;
        }
        CommonResponse msgSendResult = (CommonResponse)JSONObject.parseObject((String)((String)emailSendResult.getData()), CommonResponse.class);
        messageResponseList.addAll((Collection)msgSendResult.getData());
        return messageResponseList;
    }
}

