package com.ejianc.foundation.message.consumer;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.message.service.IMessageSendService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 消息中心基础消息拉取监听类
 */
@Component
public class MessageCommonListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMessageSendService messageSendService;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        try {
            messageSendService.handMessage(JSON.toJSONString(mqMessage.getBody()));
        } catch (Exception e) {
            logger.error("监听消息异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{PushMsgParameter.MESSAGE_COMMON_QUEUE};
    }
}
