package com.ejianc.foundation.message.controller;

import java.io.Serializable;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.nosql.redis.JedisTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.ejianc.foundation.message.config.MessageConfiguration;
import com.ejianc.foundation.message.controller.param.CheckMsgParam;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 短信发送
 * 
 * @author Administrator
 */
@Controller
@RequestMapping({"/no_auth/sms"})
public class SmsController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static final Logger logger = LoggerFactory.getLogger(SmsController.class);

	@Value("${ejc.idm.sms_service:#{null}}")
	private String smsService;
	
	@Autowired
	private JedisTemplate jedis;
	@Autowired
	private MessageConfiguration messageConfiguration;
	@Autowired
	ApplicationContext context;


	/**
	 * 发送短消息
	 * 
	 * @return
	 */
	@RequestMapping(value = { "sendMessage" }, method = { RequestMethod.POST })
	@ResponseBody
	public CommonResponse<String> sendMessage(@RequestBody SmsMessageParam param) {
		Map<String, ISmsService> filePreviewMap = context.getBeansOfType(ISmsService.class);
		if(StringUtils.isBlank(smsService)) {
			smsService = "smsServiceImpl";
		}
		return filePreviewMap.get(smsService).sendMessage(param);
	}
	
	/**
	 * 检查验证码是否正确
	 * 
	 * @return
	 */
	@RequestMapping(value = { "checkMessage" }, method = { RequestMethod.POST })
	@ResponseBody
	public CommonResponse<String> checkMessage(@RequestBody CheckMsgParam param) {
		logger.info("传输param：{}", param);
		try {
			String phone = param.getPhone();
			String templateCode = param.getTemplateCode();
			String validate = param.getValidate();
			if(StringUtils.isBlank(templateCode)) {
				throw new BusinessException("消息模板不能为空");
			}
			if(StringUtils.isBlank(phone)) {
				throw new BusinessException("手机号不能为空");
			}
			if(StringUtils.isBlank(validate)) {
				throw new BusinessException("验证码不能为空");
			}
			String ran = jedis.get(templateCode + phone);
			logger.info("传输param：{},验证结果：ran={}", param,ran);
			if(StringUtils.isBlank(ran)) {
				return CommonResponse.error("验证码已经过期或不存在，请重新获取验证码！");
			}
			if(validate.equals(ran)) {
				jedis.del(templateCode + phone);
				return CommonResponse.success("短信验证成功");
			}else{
				return CommonResponse.error("验证码错误，请确认之后重新输入！");
			}
 		}catch(Exception e) {
			e.printStackTrace();
			throw new BusinessException("系统异常，请检查传参是否合法，msg："+e.getMessage());
		}
	}
}
