package com.ejianc.foundation.message.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/")
public class TestSendMessageController {
	
	@Autowired
    private IMessageService messageService;
	
	@GetMapping("no_auth/api/getuserinfo")
	public CommonResponse<String> getuserinfo(HttpServletRequest request) {
		String code = request.getParameter("code");
		String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=wxa453c95adb68fcdc&secret=bf7a0e98380d61cf3c6ce1d18fda8a4d&code="+code+"&grant_type=authorization_code";
		
		String result = WeixinRestUtil.doGetByURL(url, null);
		
		System.out.println("=======================");
		System.out.println(result);
		return CommonResponse.success(result);
	}
	
	/**
	 * 发送系统消息
	 * 
	 * @return
	 */
	@PostMapping("test/sysmsg/send")
	public CommonResponse<String> sendSysMessage() {
		PushMsgParameter message = new PushMsgParameter();
		String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_SYS};
		message.setChannel(channel);
		String[] receivers = new String[]{"1316197441080995845"};
		message.setReceivers(receivers);
		message.setMsgType("notice");
		message.setSubject("消息提醒");
		message.setPcUrl("https://www.baidu.com/");
		message.setMobileUrl("https://www.baidu.com/");
		message.setContent("您的好友生日快到了");
		message.setTenantId("1316197441080995842");
		messageService.sendMessage(message);
		return CommonResponse.success();
	}
	
	/**
	 * 发送微信公众号消息
	 * 
	 * @return
	 */
	@PostMapping("test/weixinmsg/send")
	public CommonResponse<String> sendWexinMessage() {
		PushMsgParameter message = new PushMsgParameter();
		String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_WEIXIN};
		message.setChannel(channel);
		String[] receivers = new String[]{"303581417601122400"};
		message.setReceivers(receivers);
		message.setMsgType("notice");
		message.setTenantId("999999");
		
		JSONObject weixinParams = new JSONObject();
		weixinParams.put("template_id", "Do0q1JoHifdeXqX1-hty6DjsDY0ZNgD3GRVkFEx5jBI");
		
		JSONObject wxparams = new JSONObject();
		wxparams.put("first", "您好，您有一条待办审批提醒");
		wxparams.put("keyword1", "轻量化平台");
		wxparams.put("keyword2", "订单");
		wxparams.put("keyword3", "需要你确认下订单");
		wxparams.put("keword4", "郭明");
		wxparams.put("keyword5", "部门经理审批");
		wxparams.put("remark", "请及时审批");
		weixinParams.put("data", wxparams);
		weixinParams.put("url", "https://www.baidu.com?openid={openid}");
		message.setWeixinParams(weixinParams);
		
		messageService.sendMessage(message);
		return CommonResponse.success();
	}
	
	
	/**
	 * 发送企业微信消息
	 * 
	 * @return
	 */
	@PostMapping("test/weixineemsg/send")
	public CommonResponse<String> sendWeixinEEMessage() {
		PushMsgParameter message = new PushMsgParameter();
		String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_WEXINEE};
		message.setChannel(channel);
		String[] receivers = new String[]{"303581417601122400"};
		message.setReceivers(receivers);
		message.setMsgType("notice");
		message.setTenantId("999999");
		
		JSONObject weixineeParams = new JSONObject();
		weixineeParams.put("appid", "ww2dd60a57572d9031");
		weixineeParams.put("content", "企业微信测试消息");
		message.setWeixineeParams(weixineeParams);
		
		messageService.sendMessage(message);
		return CommonResponse.success();
	}
	
	
	@PostMapping("test/weixineetplmsg/send")
	public CommonResponse<String> sendWeixinEETplMessage() {
		PushMsgParameter message = new PushMsgParameter();
		String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_WEXINEE};
		message.setChannel(channel);
		String[] receivers = new String[]{"303581417601122400"};
		message.setReceivers(receivers);
		message.setMsgType("notice");
		message.setTenantId("999999");
		
		JSONObject weixineeParams = new JSONObject();
		weixineeParams.put("agentid", "1000004");
		weixineeParams.put("secret", "vEMLHGOgq6udMdDXuXa9MQQxANmv1wirXTQ0_XctuCQ");
		weixineeParams.put("msgtype", "textcard");
		
		weixineeParams.put("title", "消息提醒");
		weixineeParams.put("description", "消息描述信息<div style='color:red;'>少时诵诗书所所所所</div>");
		weixineeParams.put("url", "https://qlh.baju.com.cn/ejc-wzxt-mobile/#/index?userid={userid}");
		weixineeParams.put("btntxt", "点击查看");
		message.setWeixineeParams(weixineeParams);
		
		messageService.sendMessage(message);
		return CommonResponse.success();
	}
	
	/**
	 * 发送邮件消息
	 * 
	 * @return
	 */
	@PostMapping("test/emailmsg/send")
	public CommonResponse<String> sendEmailMessage() {
		PushMsgParameter message = new PushMsgParameter();
		String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_EMAIL};
		message.setChannel(channel);
		String[] receivers = new String[]{"303581417601122400"};
		message.setReceivers(receivers);
		message.setMsgType("notice");
		message.setTenantId("999999");
		message.setSubject("内容提醒");
		message.setContent("消息内容发送");
		
		messageService.sendMessage(message);
		return CommonResponse.success();
	}

	/**
	 * 发送邮件消息
	 * 
	 * @return
	 */
	@PostMapping("test/wxminprogrammsg/send")
	public CommonResponse<String> sendWeixinMinProgram() {
		PushMsgParameter message = new PushMsgParameter();
		String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_WEIXIN_MINPROGRAM};
		message.setChannel(channel);
		String[] receivers = new String[]{"303581417601122400"};
		message.setReceivers(receivers);
		message.setMsgType("notice");
		message.setTenantId("999999");
		message.setSubject("内容提醒");
		message.setContent("消息内容发送");
		
		JSONObject weixinParams = new JSONObject();
		weixinParams.put("template_id", "StEYdyZArbVJklf1Eo-78FsozHclTLK2hONqH93qDps");
		
		JSONObject wxparams = new JSONObject();
		wxparams.put("date1", "2020-10-13 20:00:00");
		wxparams.put("data2", "2020-10-13 21:00:00");
		wxparams.put("thing3", "给您带来的不便，非常抱歉");
		weixinParams.put("data", wxparams);
		message.setWeixinMinProgramParams(weixinParams);
		
		messageService.sendMessage(message);
		return CommonResponse.success();
	}
	
	/**
	 * 发送五局云消息
	 * 
	 * @return
	 */
	@PostMapping("test/wjymsg/send")
	public CommonResponse<String> sendWjyMsgProgram() {
		PushMsgParameter message = new PushMsgParameter();
		String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_WJY};
		message.setChannel(channel);
		String[] receivers = new String[]{"303581417601122400"};
		message.setReceivers(receivers);
		message.setMsgType("notice");
		message.setTenantId("999999");
		JSONObject wjyMsgParams = new JSONObject();
		wjyMsgParams.put("appid", "qlhsp_test");
		wjyMsgParams.put("from", "供方平台");
		wjyMsgParams.put("msg", "五局消息内容");
		wjyMsgParams.put("url", "http://wei.cscec5b.com.cn:9082/ejc-wzxt-mobile/#/index?userid={userid}");
		message.setWjyMsgParams(wjyMsgParams);
		messageService.sendMessage(message);
		return CommonResponse.success();
	}
}
