package com.ejianc.foundation.message.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

@Service
public class ZjwjSmsServiceImpl implements ISmsService {
	private static final Logger logger = LoggerFactory.getLogger(ZjwjSmsServiceImpl.class);
	
	private static final String SPCODE="261211";
	private static final String USER_NAME = "zj_wj";
	private static final String USER_PASSWORD = "TB0FBsggEkVwEL"; //登录密码： ZJwj12#$
	private static final String SEND_URL = "http://sms.api.ums86.com:8899/sms/Api/Send.do";
	
	@Autowired
	private JedisTemplate jedis;
	
	@Override
	public CommonResponse<String> sendMessage(SmsMessageParam param) {
		logger.debug("发送短信参数：{}", param.toString());
		try {
			if(!Validate.isMobile(param.getPhone())) {
				throw new BusinessException("手机号不合法！");
			}
			Date date = new Date();
			String timeStr = jedis.get(param.getTemplateCode()+param.getPhone()+"time");
			if(StringUtils.isNotBlank(timeStr)) {
				long ltime = Long.parseLong(timeStr);
				if((date.getTime() - ltime) / 1000L < 60L) {
					jedis.setex(param.getTemplateCode()+param.getPhone()+"time", date.getTime()+"", 600);
					return CommonResponse.error("一分钟内不能重复发送");
				}
			}
	        try {
	        	String rand = ProduceNumber.produce();
	        	HttpClient httpclient = new HttpClient();
				PostMethod post = new PostMethod(SEND_URL);
				post.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET,"gbk");
				post.addParameter("SpCode", SPCODE);
				post.addParameter("LoginName", USER_NAME);
				post.addParameter("Password", USER_PASSWORD);
				post.addParameter("MessageContent", "您的短信验证码是:"+rand+"，15分钟内有效.");
				post.addParameter("UserNumber", param.getPhone());
				post.addParameter("SerialNumber", "");
				post.addParameter("ScheduleTime", "");
				post.addParameter("ExtendAccessNum", "");
				post.addParameter("f", "1");
				httpclient.executeMethod(post);
				String info = new String(post.getResponseBody(),"gbk");
				logger.info("info="+info);
				Map<String, String> resultMap = parseResult(info);
				String code = resultMap.get("result");
				if("0".equals(code)) {
					jedis.setex(param.getTemplateCode()+param.getPhone(), rand, 600);
            		jedis.setex(param.getTemplateCode()+param.getPhone()+"time", date.getTime()+"", 600);
            		
					return CommonResponse.success("短息发送成功");
				}else{
					logger.info("短息发送失败[{}]", resultMap.get("description"));
					return CommonResponse.error(resultMap.get("description"));
				}
	        } catch (Exception e) {
	        	logger.error("方法异常[{}]", e);
	            e.printStackTrace();
	        }
		} catch(Exception e) {
			logger.error(e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("短信发送失败");
	}
	
	private static Map<String, String> parseResult(String url) {
		Map<String, String> resultMap = new HashMap<>();
		url = url.trim();
		//有参数
		String[] params = url.split("&");
		for (String param : params) {
			try {
				String[] keyValue = param.split("=");
				resultMap.put(keyValue[0], keyValue[1]);
			} catch (Exception e) {}
		}
		return resultMap;
	}

}
