/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.controller;

import com.ejianc.foundation.message.config.MessageConfiguration;
import com.ejianc.foundation.message.controller.param.CheckMsgParam;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.nosql.redis.JedisTemplate;

@Controller
@RequestMapping(value={"/no_auth/sms"})
public class SmsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SmsController.class);
    @Value(value="${ejc.idm.sms_service:#{null}}")
    private String smsService;
    @Autowired
    private JedisTemplate jedis;
    @Autowired
    private MessageConfiguration messageConfiguration;
    @Autowired
    ApplicationContext context;

    @RequestMapping(value={"sendMessage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sendMessage(@RequestBody SmsMessageParam param) {
        Map filePreviewMap = this.context.getBeansOfType(ISmsService.class);
        if (StringUtils.isBlank((CharSequence)this.smsService)) {
            this.smsService = "smsServiceImpl";
        }
        return ((ISmsService)filePreviewMap.get(this.smsService)).sendMessage(param);
    }

    @RequestMapping(value={"checkMessage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> checkMessage(@RequestBody CheckMsgParam param) {
        logger.info("\u4f20\u8f93param\uff1a{}", (Object)param);
        try {
            String phone = param.getPhone();
            String templateCode = param.getTemplateCode();
            String validate = param.getValidate();
            if (StringUtils.isBlank((CharSequence)templateCode)) {
                throw new BusinessException("\u6d88\u606f\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)phone)) {
                throw new BusinessException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)validate)) {
                throw new BusinessException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String ran = this.jedis.get(templateCode + phone);
            logger.info("\u4f20\u8f93param\uff1a{},\u9a8c\u8bc1\u7ed3\u679c\uff1aran={}", (Object)param, (Object)ran);
            if (StringUtils.isBlank((CharSequence)ran)) {
                return CommonResponse.error((String)"\u9a8c\u8bc1\u7801\u5df2\u7ecf\u8fc7\u671f\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801\uff01");
            }
            if (validate.equals(ran)) {
                this.jedis.del(new String[]{templateCode + phone});
                return CommonResponse.success((String)"\u77ed\u4fe1\u9a8c\u8bc1\u6210\u529f");
            }
            return CommonResponse.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u4e4b\u540e\u91cd\u65b0\u8f93\u5165\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u662f\u5426\u5408\u6cd5\uff0cmsg\uff1a" + e.getMessage());
        }
    }
}

