/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.service.impl.WeixinEEServiceImpl;
import com.ejianc.foundation.message.util.MailAuthenticator;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="email")
public class EmailServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(WeixinEEServiceImpl.class);
    @Autowired
    private IUserApi userApi;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
        if (userResponse.isSuccess()) {
            List userVos = (List)userResponse.getData();
            ArrayList<String> emailList = new ArrayList<String>();
            if (userVos.size() > 0) {
                for (UserVO userVo : userVos) {
                    if (StringUtils.isNotBlank((CharSequence)userVo.getUserEmail())) {
                        emailList.add(userVo.getUserEmail());
                        continue;
                    }
                    MsgSendResponse response = new MsgSendResponse("0", userVo.getUserName() + "\u90ae\u7bb1\u4e3a\u7a7a");
                    messageResponseList.add(response);
                }
            }
            JSONObject configJson = null;
            if (StringUtils.isNotBlank((CharSequence)configInfo)) {
                configJson = JSON.parseObject((String)configInfo);
            }
            String userName = configJson.getString("userName");
            String userPwd = configJson.getString("userPwd");
            String hostName = configJson.getString("hostName");
            String port = configJson.getString("port");
            Properties property = new Properties();
            property.put("mail.smtp.auth", "true");
            property.put("mail.smtp.host", hostName);
            property.put("mail.smtp.port", port);
            MailAuthenticator authenticator = new MailAuthenticator(userName, userPwd);
            Session mailSession = Session.getInstance((Properties)property, (Authenticator)authenticator);
            try {
                MimeMultipart multipart = new MimeMultipart();
                MimeMessage message = new MimeMessage(mailSession);
                InternetAddress sendAddress = new InternetAddress(userName);
                message.setFrom((Address)sendAddress);
                if (emailList.size() > 0) {
                    InternetAddress[] emailAddressArray = new InternetAddress[emailList.size()];
                    for (int i = 0; i < emailList.size(); ++i) {
                        emailAddressArray[i] = new InternetAddress((String)emailList.get(i));
                    }
                    message.setRecipients(Message.RecipientType.TO, (Address[])emailAddressArray);
                    message.setSentDate(new Date());
                    message.setSubject(pushMsgParameter.getSubject());
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setContent((Object)pushMsgParameter.getContent(), "text/html;charset=utf-8");
                    multipart.addBodyPart((BodyPart)bodyPart);
                    message.setContent((Multipart)multipart);
                    Transport.send((Message)message);
                }
                logger.info("\u53d1\u9001\u90ae\u4ef6\u6210\u529f!");
            }
            catch (Exception e) {
                logger.info("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0cMsg:", (Object)e.getMessage());
            }
        }
        return messageResponseList;
    }
}

