/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.MessageOutLinkEntity;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.service.IMessageOutLinkService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.ZDSEmailSendVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="zdsEmail")
public class ZdsEmailServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(ZdsEmailServiceImpl.class);
    @Autowired
    private IUserApi userApi;
    @Value(value="${ejc.sms.zds.erp.appId:0}")
    private String appId;
    @Value(value="${ejc.sms.zds.erp.secret:0}")
    private String secret;
    @Value(value="${ejc.sms.zds.erp.reqHost:0}")
    private String reqHost;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${ejc.sms.zds.ssoReqUrl:0}")
    private String ssoReqUrl;
    @Value(value="${ejc.sms.zds.erp.emailTemplate:0}")
    private String defaultEmailTemplate;
    @Value(value="${ejc.sms.zds.erp.emailModule:0}")
    private String defaultEmailModule;
    @Value(value="${ejc.sms.zds.erp.defaultFrom:\u4f9b\u5e94\u94fe\u5e73\u53f0}")
    private String defaultFrom;
    @Autowired
    private IMessageOutLinkService messageOutLinkService;
    private final String ZDS_EMAIL_SEND_URL = "/cefoc/yql/CreateSendEmail";

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        ArrayList<ZDSEmailSendVO> sendList;
        ArrayList<MsgSendResponse> messageResponseList;
        block11: {
            block10: {
                messageResponseList = new ArrayList<MsgSendResponse>();
                sendList = new ArrayList<ZDSEmailSendVO>();
                if (null == pushMsgParameter.getReceivers() || pushMsgParameter.getReceivers().length <= 0) break block10;
                CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
                ArrayList<MessageOutLinkEntity> saveLinks = new ArrayList<MessageOutLinkEntity>();
                if (!userResponse.isSuccess()) break block11;
                List userVos = (List)userResponse.getData();
                if (userVos.size() > 0) {
                    for (String[] userVo : userVos) {
                        if (StringUtils.isNotBlank((CharSequence)userVo.getUserEmail())) {
                            this.getEmailSendParam(pushMsgParameter, (UserVO)userVo, sendList, messageResponseList, saveLinks);
                            continue;
                        }
                        logger.info("\u5411\u4eba\u5458\u3010{}\u3011\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u4eba\u5458\u90ae\u7bb1\u4e3a\u7a7a", (Object)userVo.getUserName());
                        MsgSendResponse response = new MsgSendResponse("0", "\u5411\u4eba\u5458\u3010" + userVo.getUserName() + "\u3011\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u4eba\u5458\u90ae\u7bb1\u4e3a\u7a7a");
                        messageResponseList.add(response);
                    }
                }
                if (!CollectionUtils.isNotEmpty(saveLinks)) break block11;
                this.messageOutLinkService.saveOrUpdateBatch(saveLinks, saveLinks.size(), false);
                break block11;
            }
            if (null != pushMsgParameter.getZdsExtEmailParams() && null != pushMsgParameter.getZdsExtEmailParams().getString("userEmails")) {
                String[] userName;
                String[] userEmails = pushMsgParameter.getZdsExtEmailParams().getString("userEmails").split(",");
                if (userEmails.length != (userName = pushMsgParameter.getZdsExtEmailParams().getString("userNames").split(",")).length) {
                    logger.error("\u4e2d\u7535\u56db\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u63a5\u6536\u4eba\u90ae\u7bb1\u5217\u8868\u3010{}\u3011\u4e0e\u63a5\u6536\u4eba\u540d\u79f0\u3010{}\u3011\u4e0d\u5339\u914d!", (Object)pushMsgParameter.getZdsExtEmailParams().getString("userEmails"), (Object)pushMsgParameter.getZdsExtEmailParams().getString("userNames"));
                    throw new BusinessException("\u4e2d\u7535\u56db\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u63a5\u6536\u4eba\u90ae\u7bb1\u5217\u8868\u4e0e\u63a5\u6536\u4eba\u540d\u79f0\u4e0d\u5339\u914d!");
                }
                UserVO tmpUser = new UserVO();
                Integer idx = 0;
                for (String email : userEmails) {
                    tmpUser.setUserEmail(email);
                    tmpUser.setUserName(userName[idx]);
                    Integer n = idx;
                    Integer n2 = idx = Integer.valueOf(idx + 1);
                    this.getEmailSendParam(pushMsgParameter, tmpUser, sendList, messageResponseList, null);
                }
            }
        }
        try {
            Map<String, String> headers = ZdsEmailServiceImpl.getErpHeaders(this.appId, this.secret);
            String reqResp = null;
            JSONObject respJson = null;
            for (ZDSEmailSendVO zdsEmailSendVO : sendList) {
                MsgSendResponse response;
                reqResp = HttpTookit.postByJson((String)(this.reqHost + "/cefoc/yql/CreateSendEmail"), (String)JSONObject.toJSONString((Object)zdsEmailSendVO), headers, (Integer)10000, (Integer)10000);
                respJson = JSONObject.parseObject((String)reqResp);
                logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{this.reqHost + "/cefoc/yql/CreateSendEmail", JSONObject.toJSONString((Object)zdsEmailSendVO), JSONObject.toJSONString(headers), reqResp});
                if ("ok".equals(respJson.getString("Status"))) {
                    response = new MsgSendResponse("1", "\u5411\u4eba\u5458\u3010" + (String)zdsEmailSendVO.getJsonObject().get("receiverName") + "\u3011\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
                    messageResponseList.add(response);
                    continue;
                }
                logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{this.reqHost + "/cefoc/yql/CreateSendEmail", JSONObject.toJSONString((Object)zdsEmailSendVO), JSONObject.toJSONString(headers), reqResp});
                response = new MsgSendResponse("0", "\u8c03\u7528ERP\u63a5\u53e3\u5411\u4eba\u5458\u3010" + (String)zdsEmailSendVO.getJsonObject().get("receiverName") + "\u3011\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01");
                messageResponseList.add(response);
            }
            logger.info("\u53d1\u9001\u90ae\u4ef6\u5b8c\u6210!");
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
        return messageResponseList;
    }

    private void getEmailSendParam(PushMsgParameter pushMsgParameter, UserVO userVo, List<ZDSEmailSendVO> sendList, List<MsgSendResponse> messageResponseList, List<MessageOutLinkEntity> saveLinks) {
        ZDSEmailSendVO sendParams = null;
        if (null != pushMsgParameter.getZdsExtEmailParams() && "false".equals(pushMsgParameter.getZdsExtEmailParams().getString("defaultModule"))) {
            if (null == pushMsgParameter.getZdsExtEmailParams().get((Object)"sendParam") || null == pushMsgParameter.getZdsExtEmailParams().get((Object)"jsonObject")) {
                MsgSendResponse response = new MsgSendResponse("0", "\u90ae\u4ef6\u53d1\u9001\u81ea\u5b9a\u4e49\u53c2\u6570\uff1a\u3010sendParam\u3011\u4e3a\u7a7a");
                messageResponseList.add(response);
            } else {
                sendParams = (ZDSEmailSendVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pushMsgParameter.getZdsExtEmailParams().get((Object)"sendParam")), ZDSEmailSendVO.class);
                sendList.add(sendParams);
            }
        } else {
            sendParams = new ZDSEmailSendVO();
            sendParams.setTitle(pushMsgParameter.getSubject());
            sendParams.setAddress(userVo.getUserEmail());
            sendParams.setTemplate(this.defaultEmailTemplate);
            sendParams.setModule(this.defaultEmailModule);
            sendParams.setPcTitle(pushMsgParameter.getPcTitle());
            Hashtable<String, String> templateParams = new Hashtable<String, String>();
            templateParams.put("receiverName", userVo.getUserName());
            templateParams.put("msgContent", pushMsgParameter.getContent());
            sendParams.setJsonObject(templateParams);
            sendParams.setPcUrl(pushMsgParameter.getPcUrl());
            sendParams.setMobileUrl(pushMsgParameter.getMobileUrl());
        }
        String comeFrom = null;
        if (pushMsgParameter.getZdsExtEmailParams() != null && pushMsgParameter.getZdsExtEmailParams().getString("comeFrom") != null) {
            comeFrom = pushMsgParameter.getZdsExtEmailParams().getString("comeFrom");
        }
        sendParams.getJsonObject().put("msgLink", this.baseHost + this.ssoReqUrl);
        sendParams.getJsonObject().put("comeFrom", Optional.ofNullable(comeFrom).orElse(this.defaultFrom));
        sendParams.getJsonObject().put("msgLinkFlag", "hidden");
        if ((null != sendParams.getPcUrl() || null != sendParams.getMobileUrl()) && null != saveLinks) {
            saveLinks.add(this.getLinksByEmailParam(sendParams, userVo.getId()));
        }
        sendList.add(sendParams);
    }

    private MessageOutLinkEntity getLinksByEmailParam(ZDSEmailSendVO sendParams, Long userId) {
        MessageOutLinkEntity entity = new MessageOutLinkEntity();
        entity.setUserId(userId);
        entity.setId(IdWorker.getId());
        if (StringUtils.isNotBlank((CharSequence)sendParams.getPcUrl())) {
            entity.setPcUrl(sendParams.getPcUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)sendParams.getMobileUrl())) {
            entity.setMobileUrl(sendParams.getMobileUrl() + (sendParams.getMobileUrl().contains("?") ? "&userid=" : "?userid=") + userId);
        }
        entity.setExtParam1(JSONObject.toJSONString((Object)sendParams));
        entity.setExtParam2(sendParams.getPcTitle());
        sendParams.getJsonObject().put("msgLinkFlag", "visible");
        sendParams.getJsonObject().put("msgLink", (String)sendParams.getJsonObject().get("msgLink") + "?ticket=" + entity.getId().toString());
        return entity;
    }

    public static Map<String, String> getErpHeaders(String appId, String secret) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        headers.put("appid", ZdsEmailServiceImpl.toMD5(appId));
        headers.put("ticket", nowStr);
        headers.put("sign", ZdsEmailServiceImpl.toMD5(secret + ZdsEmailServiceImpl.toMD5(appId) + ZdsEmailServiceImpl.toMD5(nowStr)));
        return headers;
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }
}

