package com.ejianc.foundation.message.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.message.bean.OftenUseStatementEntity;
import com.ejianc.foundation.message.service.IOftenUseStatementService;
import com.ejianc.foundation.message.vo.OftenUseStatementVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/statement/")
public class OftenUseStatementController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOftenUseStatementService oftenUseStatementService;

    @PostMapping("saveOrUpdate")
    @ResponseBody
    CommonResponse<OftenUseStatementVO> saveOrUpdate(@RequestBody OftenUseStatementVO saveOrUpdate) {
        OftenUseStatementEntity entity = BeanMapper.map(saveOrUpdate, OftenUseStatementEntity.class);
        oftenUseStatementService.saveOrUpdate(entity, false);
        saveOrUpdate = BeanMapper.map(entity, OftenUseStatementVO.class);
        return CommonResponse.success(saveOrUpdate);
    }

    /**
     * 获取常用语句分页列表
     *
     * @return CommonResponse<IPage < OftenUseStatementVO>> 包含常用语句列表的响应对象
     */
    @PostMapping("pageList")
    @ResponseBody
    CommonResponse<IPage<OftenUseStatementVO>> pageList(@RequestBody QueryParam queryParam) {

        IPage<OftenUseStatementEntity> page = oftenUseStatementService.queryPage(queryParam, false);
        List<OftenUseStatementVO> saveOrUpdate = BeanMapper.mapList(page.getRecords(), OftenUseStatementVO.class);
        IPage<OftenUseStatementVO> page1 = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        page1.setRecords(saveOrUpdate);
        return CommonResponse.success(page1);
    }

    /**
     * 删除
     *
     * @return CommonResponse<String>
     */
    @PostMapping("delete")
    @ResponseBody
    CommonResponse<String> delete(@RequestBody List<Long> ids) {
        oftenUseStatementService.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }


    /**
     * 获取常用语句列表
     *
     * @return CommonResponse<List < OftenUseStatementVO>> 包含常用语句列表的响应对象
     */
    @GetMapping("getOftenUseStatementList")
    @ResponseBody
    CommonResponse<List<OftenUseStatementVO>> getOftenUseStatementList() {
        List<OftenUseStatementVO> res = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("state", Parameter.getEqInstance("1"));
        queryParam.getOrderMap().put("sequence", QueryParam.ASC);
        List<OftenUseStatementEntity> list = oftenUseStatementService.queryList(queryParam, false);
        if (list != null) {
            res = BeanMapper.mapList(list, OftenUseStatementVO.class);
        }
        return CommonResponse.success(res);
    }

    @GetMapping("getLastSequence")
    @ResponseBody
    CommonResponse<Integer> getLastSequence() {
        int res = 0;
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("sequence", QueryParam.DESC);
        List<OftenUseStatementEntity> list = oftenUseStatementService.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            res = list.get(0).getSequence() + 1;
        }
        return CommonResponse.success(res);
    }

    /**
     * 根据问题内容获取答案。
     * <p>
     * 通过查询预设的问题回答数据库，根据提供的问题内容查找相应的答案。
     * 如果找到答案，则返回该答案；如果未找到答案，则返回空。
     * </p>
     * @param content 问题的内容
     * @return 匹配到的答案或者空
     */
    @GetMapping("getAnswerByContent")
    @ResponseBody
    CommonResponse<String> getAnswerByContent(@RequestParam String content) throws InterruptedException {
        // 初始化答案变量
        String res = null;
        // 创建查询参数对象
        QueryParam queryParam = new QueryParam();
        // 设置查询参数为问题的内容
        queryParam.getParams().put("content", Parameter.getEqInstance(content));
        // 查询预设的问题回答列表
        List<OftenUseStatementEntity> list = oftenUseStatementService.queryList(queryParam, false);
        // 如果查询结果不为空，则获取第一个答案
        if (ListUtil.isNotEmpty(list)) {
            res = list.get(0).getAnswer();
        }
        Thread.sleep(1500);
        // 返回查询结果，如果未找到答案则返回空
        return CommonResponse.success("查询成功！",res);
    }

}
