package com.ejianc.foundation.message.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.vo.MessageVO;
import com.ejianc.foundation.message.vo.PageParam;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/7/17 20:09
 */
@RestController
@RequestMapping("/api/userMsg/")
public class MessageApi {

    @Autowired
    private IMessageService messageService;

    /**
     * 查询用户指定条件的消息数量
     *
     * @param pageParam
     * @return
     */
    @PostMapping("countUserMsg")
    CommonResponse<Long> countUserMsg(@RequestBody PageParam pageParam) {
        Long total = messageService.queryCount(pageParam);
        return CommonResponse.success("查询用户消息数量成功！", total);
    }

    /**
     * 分页查询用户消息列表
     *
     * @param pageParam
     * @return
     */
    @PostMapping("pageList")
    CommonResponse<JSONObject> pageList(@RequestBody PageParam pageParam) {
        JSONObject resp = new JSONObject();
        JSONObject result = new JSONObject();
        List<MessageVO> voList = null;
        long count = messageService.queryCount(pageParam);
        if(count > 0) {
            voList = messageService.queryList(pageParam);
        }else{
            voList = new ArrayList<>();
        }

        result.put("total", count);
        result.put("pageSize", pageParam.getPageSize());
        result.put("pageNum", pageParam.getPageNum());
        result.put("records", voList);
        resp.put("data", result);
        return CommonResponse.success("查询用户消息列表成功！", resp);
    }
}
