package com.ejianc.foundation.message.dispatch;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.message.bean.MsgChannelEntity;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.exception.BusinessException;

public class MessageSend {
    private PushMsgParameter pushMsgParameter;
    private MsgChannelEntity channel;
    private Map<String, String> channelImpl;

    public MessageSend(PushMsgParameter messageParam, MsgChannelEntity channel) {
        this.pushMsgParameter = messageParam;
        this.channel = channel;
    }

    public MessageSend(PushMsgParameter pushMsgParameter, MsgChannelEntity channel, Map<String, String> channelImpl) {
        this.pushMsgParameter = pushMsgParameter;
        this.channel = channel;
        this.channelImpl = channelImpl;
    }

    public List<MsgSendResponse> send() throws BusinessException {
        IMsgSendChannelProcessor processor = SendChannelExtFactory.getInstance(null != channelImpl && channelImpl.containsKey(channel.getType()) ?
                channelImpl.get(channel.getType()) : this.channel.getType());
        return processor.send(channel.getConfigInfo(), pushMsgParameter);
    }
    
}
