package com.ejianc.foundation.message.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.MailAuthenticator;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;

@Service("email")
public class EmailServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(WeixinEEServiceImpl.class);

	@Autowired
	private IUserApi userApi;
	
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			
			List<String> emailList = new ArrayList<String>();
			if(userVos.size() > 0) {
				for(UserVO userVo:userVos) {
					if(StringUtils.isNotBlank(userVo.getUserEmail())) {
						emailList.add(userVo.getUserEmail());
					}else{
						MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, userVo.getUserName()+"邮箱为空");
						messageResponseList.add(response);
					}
				}
			}
			JSONObject configJson = null;
			if (StringUtils.isNotBlank(configInfo)) {
				configJson = JSON.parseObject(configInfo);
			}
			String userName = configJson.getString("userName");
			String userPwd = configJson.getString("userPwd");
			String hostName = configJson.getString("hostName");
			String port = configJson.getString("port");

			Properties property = new Properties();
			property.put("mail.smtp.auth", "true");
			property.put("mail.smtp.host", hostName);
			property.put("mail.smtp.port", port);

			MailAuthenticator authenticator = new MailAuthenticator(userName, userPwd);

			Session mailSession = Session.getInstance(property, authenticator);
			try {
				Multipart multipart = new MimeMultipart();
				MimeMessage message = new MimeMessage(mailSession);
				InternetAddress sendAddress = new InternetAddress(userName);
				message.setFrom(sendAddress);
				
				if(emailList.size() > 0) {
					InternetAddress[] emailAddressArray = new InternetAddress[emailList.size()];
					for(int i=0;i<emailList.size();i++) {
						emailAddressArray[i] = new InternetAddress(emailList.get(i));
					}
					message.setRecipients(Message.RecipientType.TO, emailAddressArray);
					message.setSentDate(new Date());
					
					message.setSubject(pushMsgParameter.getSubject());
					
					BodyPart bodyPart = new MimeBodyPart();
					bodyPart.setContent(pushMsgParameter.getContent(), "text/html;charset=utf-8");
					multipart.addBodyPart(bodyPart);
					
					message.setContent(multipart);
					Transport.send(message);
				}
				
				logger.info("发送邮件成功!");
			} catch (Exception e) {
				logger.info("邮件发送失败，Msg:", e.getMessage());
			}
		}
		
		return messageResponseList;
	}

}
