package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.SocketMessageLogEntity;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.service.ISocketMessageService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.SocketMessageLogVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("websocket")
public class SocketChannelServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(SocketChannelServiceImpl.class);

	@Value("${common.env.base-host}")
	private String baseHost;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private ISocketMessageService websocket;

	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter parameter) {

		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();

		logger.info("websocket通道 收到待发Socket消息：{}",JSONObject.toJSONString(parameter));
		Map<String, Long> msgIds = new HashMap<>();
		String sendUrl = baseHost + "ejc-webpush/event/send";
		for(String userId : parameter.getReceivers()) {
			Long msgId = IdWorker.getId();
			//4、向用户所有有效的会话发送打开应用指令
			Map<String, String> userSessions = sessionManager.getUserSessionMap(Long.valueOf(userId));
			JSONObject tabParam = new JSONObject();
			tabParam.put("msgType", parameter.getMsgType());
			tabParam.put("msgTitle", parameter.getSubject());
			tabParam.put("msgId", msgId.toString());
			tabParam.put("pcUrl", parameter.getPcUrl());
			tabParam.put("pcTitle", parameter.getPcTitle());
			tabParam.put("mobileUrl", parameter.getMobileUrl());
			tabParam.put("attachIds",parameter.getAttachIds());
			tabParam.put("content",parameter.getContent());
			for(String token : userSessions.keySet()) {
				Map<String, String> paramMap = new HashMap<>();
				paramMap.put("token", token);
				paramMap.put("type", "sysMsg");
				paramMap.put("value", tabParam.toJSONString());
				try {
					logger.info("向webpush发送websocket消息url:{}, 参数：{}", sendUrl, JSON.toJSONString(paramMap));
					HttpTookit.postByJson(sendUrl, JSON.toJSONString(paramMap));
				} catch (Exception e) {
					logger.error("向webpush发送消息失败；", e);
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "向webpush发送消息失败: - "+e.getMessage());
					messageResponseList.add(response);
				}
			}
			SocketMessageLogEntity message = new SocketMessageLogEntity();
			message.setContent(tabParam.toJSONString());
			message.setId(msgId);
			message.setUserId(Long.valueOf(userId));
			message.setSendTime(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND, new Date()));
			message.setMsgType(SocketMessageLogVO.ROBOT);
			if(InvocationInfoProxy.getTenantid()==null){
				message.setTenantId(parameter.getTenantId()!=null?Long.parseLong(parameter.getTenantId()):999999);
			}
			websocket.saveOrUpdate(message,false);
			msgIds.put(userId, msgId);
			logger.info("socket 通道 消息持久化成功：{}", JSON.toJSONString(message));
		}
		return messageResponseList;
	}
}
