package com.ejianc.foundation.message.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;

@Service("weixinSupplier")
public class WeixinSupplierServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(WeixinSupplierServiceImpl.class);
	
	@Autowired
	private IUserApi userApi;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		
		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		JSONObject weixinJson = pushMsgParameter.getWeixinParams();
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			JSONObject templateJson = new JSONObject();
			templateJson.put("template_id", weixinJson.getString("template_id"));
			//data属性
			JSONObject wxparams = weixinJson.getJSONObject("data");
			if(wxparams != null && !wxparams.isEmpty()) {
				JSONObject wxparamJson = new JSONObject();
				for(String key:wxparams.keySet()) {
					JSONObject keyJson = new JSONObject();
					keyJson.put("value", wxparams.get(key));
					if("remark".equals(key)) {
						keyJson.put("color", "#0274f2");
					}
					wxparamJson.put(key, keyJson);
				}
				templateJson.put("data", wxparamJson);
			}
			//小程序
			JSONObject miniprogram = weixinJson.getJSONObject("miniprogram");

			for(UserVO userVo:userVos) {
				if(StringUtils.isBlank(userVo.getWeixinId())) {
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "微信模板消息发送失败", userVo.getWeixinId());
					logger.info("向" + userVo.getWeixinId() + "发送微信失败!");
					messageResponseList.add(response);
					continue;
				}
				
				String wxurl = weixinJson.getString("url");
				if(StringUtils.isNotBlank(wxurl)) {
					wxurl = wxurl.replaceAll("%7Bopenid%7D", userVo.getWeixinId()).replaceAll("%7bopenid%7d", userVo.getWeixinId()).replaceAll("\\{openid\\}", userVo.getWeixinId());
					templateJson.put("url", wxurl);
				}
				if(miniprogram != null && !miniprogram.isEmpty()) {
					String pagepath = null != miniprogram.get("pagepath") ? miniprogram.getString("pagepath") : null;
					if(StringUtils.isNotBlank(pagepath)) {
						pagepath = pagepath.replaceAll("%7Bopenid%7D", userVo.getWeixinId()).replaceAll("%7bopenid%7d", userVo.getWeixinId()).replaceAll("\\{openid\\}", userVo.getWeixinId());
						miniprogram.put("pagepath", pagepath);
					}
					templateJson.put("miniprogram", miniprogram);
				}

				templateJson.put("touser", userVo.getWeixinId());
				
				String templateContent = JSON.toJSONString(templateJson);
				logger.info("微信发送信息,{}",templateContent);
				String appid = configJson.getString("appid");
				String secret = configJson.getString("secret");
				
				String accessToken = getWeixinAccessToken(appid, secret, false);
				logger.info("access_token = "+accessToken);
				String templateResult = WeixinRestUtil.doPostByURL("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token="+accessToken, templateContent);
				JSONObject httpResult = JSON.parseObject(templateResult);
				if(httpResult != null) {
					logger.info("weixin_response = "+JSON.toJSONString(httpResult));
				}
				if ("ok".equals(httpResult.get("errmsg"))) {
					logger.info("向" + userVo.getWeixinId() + "发送微信成功!");
				} else {
					if("40001".equals(httpResult.getString("errcode"))) {
						//该问题可能是access_token过期导致，清除redis中缓存的access_token
						getWeixinAccessToken(appid, secret, true);
					}
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "微信模板消息发送失败", userVo.getWeixinId());
					logger.info("向" + userVo.getWeixinId() + "发送微信失败!");
					messageResponseList.add(response);
				}
			}
		}
		return messageResponseList;
	}

	public String getWeixinAccessToken(String appid, String secret, boolean reload) {
		String key = appid+"_"+secret;
		String accessToken = (String) redisTemplate.opsForValue().get(key);
		logger.info("redis----accessToken="+accessToken);
		System.out.println("redis----accessToken="+accessToken);
		if(StringUtils.isBlank(accessToken) || reload) {
			String accessResult = WeixinRestUtil.doGetByURL("https://api.weixin.qq.com/cgi-bin/token", "grant_type=client_credential&appid="+appid+"&secret="+secret);
			logger.info("accessResult="+accessResult);
			System.out.println("accessResult="+accessResult);
			if(StringUtils.isNotBlank(accessResult)) {
				JSONObject accessJson = JSON.parseObject(accessResult);
				accessToken = accessJson.getString("access_token");
				if(StringUtils.isNotBlank(accessToken)) {
					redisTemplate.opsForValue().set(key, accessToken, 7000, TimeUnit.SECONDS);
				}
			}
		}
		return accessToken;
	}

}
