/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.SocketMessageLogEntity;
import com.ejianc.foundation.message.service.ISocketMessageService;
import com.ejianc.foundation.message.vo.SocketMsgParameter;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/message/"})
public class SocketMessageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISocketMessageService websocket;

    @PostMapping(value={"sendWebsocketMessage"})
    public CommonResponse<Map<String, Long>> pushWebsocketMessage(@RequestBody SocketMsgParameter parameter) {
        this.logger.info("\u6536\u5230\u5f85\u53d1Socket\u6d88\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)parameter));
        HashMap<String, Long> msgIds = new HashMap<String, Long>();
        String sendUrl = this.baseHost + "ejc-webpush/event/send";
        for (String userId : parameter.getReceivers()) {
            Long msgId = IdWorker.getId();
            Map userSessions = this.sessionManager.getUserSessionMap(Long.valueOf(userId));
            JSONObject tabParam = new JSONObject();
            tabParam.put("msgType", (Object)parameter.getMsgType());
            tabParam.put("msgTitle", (Object)parameter.getSubject());
            tabParam.put("msgId", (Object)msgId.toString());
            tabParam.put("pcUrl", (Object)parameter.getPcUrl());
            tabParam.put("keyValueContent", (Object)parameter.getKeyValueContent());
            tabParam.put("pcTitle", (Object)parameter.getPcTitle());
            tabParam.put("mobileUrl", (Object)parameter.getMobileUrl());
            tabParam.put("attachIds", (Object)parameter.getAttachIds());
            tabParam.put("content", (Object)parameter.getContent());
            tabParam.put("msgState", (Object)parameter.getState());
            for (String token : userSessions.keySet()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("token", token);
                paramMap.put("type", "sysMsg");
                paramMap.put("value", tabParam.toJSONString());
                try {
                    this.logger.info("\u5411webpush\u53d1\u9001websocket\u6d88\u606furl:{}, \u53c2\u6570\uff1a{}", (Object)sendUrl, (Object)JSON.toJSONString(paramMap));
                    HttpTookit.postByJson((String)sendUrl, (String)JSON.toJSONString(paramMap));
                }
                catch (Exception e) {
                    this.logger.error("\u5411webpush\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1b", (Throwable)e);
                }
            }
            SocketMessageLogEntity message = new SocketMessageLogEntity();
            message.setContent(tabParam.toJSONString());
            message.setId(msgId);
            message.setState(parameter.getState());
            message.setUserId(Long.valueOf(userId));
            message.setSendTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
            message.setMsgType("robot");
            if (InvocationInfoProxy.getTenantid() == null) {
                message.setTenantId(parameter.getTenantId() != null ? Long.parseLong(parameter.getTenantId()) : 999999L);
            }
            this.websocket.saveOrUpdate((Object)message, false);
            msgIds.put(userId, msgId);
            this.logger.info("sys\u6d88\u606f\u8f6csocket\u6d88\u606f\u6301\u4e45\u5316\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)((Object)message)));
        }
        return CommonResponse.success(msgIds);
    }

    @PostMapping(value={"updateWebsocketMessageStatus"})
    public CommonResponse<String> updateWebsocketMessageStatus(@RequestBody List<Long> msgIds) {
        String sendUrl = this.baseHost + "ejc-webpush/event/send";
        this.logger.info("\u66f4\u65b0websocket\u6d88\u606f\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString(msgIds));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", msgIds));
        List list = this.websocket.queryList(queryParam, false);
        for (SocketMessageLogEntity entity : list) {
            entity.setState("user");
            this.websocket.saveOrUpdate((Object)entity, false);
            Map userSessions = this.sessionManager.getUserSessionMap(entity.getUserId());
            JSONObject tabParam = new JSONObject();
            tabParam.put("msgType", (Object)"updateMsgState");
            tabParam.put("msgId", (Object)entity.getId().toString());
            tabParam.put("msgState", (Object)"user");
            for (String token : userSessions.keySet()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("token", token);
                paramMap.put("type", "sysMsg");
                paramMap.put("value", tabParam.toJSONString());
                try {
                    this.logger.info("\u5411webpush\u53d1\u9001websocket \u66f4\u65b0\u6d88\u606f\u72b6\u6001\u6d88\u606furl:{}, \u53c2\u6570\uff1a{}", (Object)sendUrl, (Object)JSON.toJSONString(paramMap));
                    HttpTookit.postByJson((String)sendUrl, (String)JSON.toJSONString(paramMap));
                }
                catch (Exception e) {
                    this.logger.error("\u5411webpush \u66f4\u65b0\u6d88\u606f\u72b6\u6001\u6d88\u606f \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1b", (Throwable)e);
                }
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

