/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.CdgwSmsUtils;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

@Service(value="cdgwSmsService")
public class CdgwSmsServiceImpl
implements ISmsService {
    private static final Logger logger = LoggerFactory.getLogger(CdgwSmsServiceImpl.class);
    @Autowired
    private JedisTemplate jedis;

    @Override
    public CommonResponse<String> sendMessage(SmsMessageParam param) {
        logger.debug("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a{}", (Object)param.toString());
        try {
            if (!Validate.isMobile(param.getPhone())) {
                throw new BusinessException("\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\uff01");
            }
            Date date = new Date();
            String timeStr = this.jedis.get(param.getTemplateCode() + param.getPhone() + "time");
            if (StringUtils.isNotBlank((CharSequence)timeStr)) {
                long ltime = Long.parseLong(timeStr);
                if ((date.getTime() - ltime) / 1000L < 60L) {
                    this.jedis.setex(param.getTemplateCode() + param.getPhone() + "time", date.getTime() + "", 600);
                    return CommonResponse.error((String)"\u4e00\u5206\u949f\u5185\u4e0d\u80fd\u91cd\u590d\u53d1\u9001");
                }
            }
            try {
                String rand = ProduceNumber.produce();
                String content = null;
                content = param != null && StringUtils.isNotBlank((CharSequence)param.getTemplateCode()) && !"SMS_463607583".equals(param.getTemplateCode()) ? param.getMsgContent() : "\u9a8c\u8bc1\u7801\uff1a" + rand + "\uff08\u6210\u90fd\u56fd\u4e07\u5ba2\u670d\u7edd\u5bf9\u4e0d\u4f1a\u7d22\u8981\u9a8c\u8bc1\u7801\uff0c\u5207\u52ff\u544a\u8bc9\u4ed6\u4eba\uff09,\u611f\u8c22\u60a8\u7684\u652f\u6301";
                ArrayList<String> phones = new ArrayList<String>();
                phones.add(param.getPhone());
                String responseStr = CdgwSmsUtils.sendMsg(phones, content);
                logger.info("======" + responseStr);
                JSONObject responseJson = JSON.parseObject((String)responseStr);
                String status = responseJson.getString("resultcode");
                if ("success".equals(status)) {
                    logger.info("======" + status + ":ok");
                    this.jedis.setex(param.getTemplateCode() + param.getPhone(), rand, 600);
                    this.jedis.setex(param.getTemplateCode() + param.getPhone() + "time", date.getTime() + "", 600);
                    return CommonResponse.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
    }
}

