/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.bean.SocketMessageLogEntity;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.service.ISocketMessageService;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="websocket")
public class SocketChannelServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(SocketChannelServiceImpl.class);
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISocketMessageService websocket;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter parameter) {
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        logger.info("websocket\u901a\u9053 \u6536\u5230\u5f85\u53d1Socket\u6d88\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)parameter));
        HashMap<String, Long> msgIds = new HashMap<String, Long>();
        String sendUrl = this.baseHost + "ejc-webpush/event/send";
        for (String userId : parameter.getReceivers()) {
            Long msgId = IdWorker.getId();
            Map userSessions = this.sessionManager.getUserSessionMap(Long.valueOf(userId));
            JSONObject tabParam = new JSONObject();
            tabParam.put("msgType", (Object)parameter.getMsgType());
            tabParam.put("msgTitle", (Object)parameter.getSubject());
            tabParam.put("msgId", (Object)msgId.toString());
            tabParam.put("pcUrl", (Object)parameter.getPcUrl());
            tabParam.put("pcTitle", (Object)parameter.getPcTitle());
            tabParam.put("mobileUrl", (Object)parameter.getMobileUrl());
            tabParam.put("attachIds", (Object)parameter.getAttachIds());
            tabParam.put("content", (Object)parameter.getContent());
            for (String token : userSessions.keySet()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("token", token);
                paramMap.put("type", "sysMsg");
                paramMap.put("value", tabParam.toJSONString());
                try {
                    logger.info("\u5411webpush\u53d1\u9001websocket\u6d88\u606furl:{}, \u53c2\u6570\uff1a{}", (Object)sendUrl, (Object)JSON.toJSONString(paramMap));
                    HttpTookit.postByJson((String)sendUrl, (String)JSON.toJSONString(paramMap));
                }
                catch (Exception e) {
                    logger.error("\u5411webpush\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1b", (Throwable)e);
                    MsgSendResponse response = new MsgSendResponse("0", "\u5411webpush\u53d1\u9001\u6d88\u606f\u5931\u8d25: - " + e.getMessage());
                    messageResponseList.add(response);
                }
            }
            SocketMessageLogEntity message = new SocketMessageLogEntity();
            message.setContent(tabParam.toJSONString());
            message.setId(msgId);
            message.setUserId(Long.valueOf(userId));
            message.setSendTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
            message.setMsgType("robot");
            if (InvocationInfoProxy.getTenantid() == null) {
                message.setTenantId(parameter.getTenantId() != null ? Long.parseLong(parameter.getTenantId()) : 999999L);
            }
            this.websocket.saveOrUpdate((Object)message, false);
            msgIds.put(userId, msgId);
            logger.info("socket \u901a\u9053 \u6d88\u606f\u6301\u4e45\u5316\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)((Object)message)));
        }
        return messageResponseList;
    }
}

