/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodeVO;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"designsubcontractnode"})
public class DesignsubcontractnodeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDesignsubcontractnodeService service;
    @Autowired
    private IDesignsubcontractnodedetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DesignsubcontractnodeVO> saveOrUpdate(@RequestBody DesignsubcontractnodeVO saveorUpdateVO) {
        DesignsubcontractnodeEntity entity = (DesignsubcontractnodeEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DesignsubcontractnodeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DesignsubcontractnodeVO vo = (DesignsubcontractnodeVO)((Object)BeanMapper.map((Object)((Object)entity), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DesignsubcontractnodeVO> queryDetail(Long id) {
        DesignsubcontractnodeEntity entity = (DesignsubcontractnodeEntity)((Object)this.service.selectById(id));
        DesignsubcontractnodeVO vo = (DesignsubcontractnodeVO)((Object)BeanMapper.map((Object)((Object)entity), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DesignsubcontractnodeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DesignsubcontractnodeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List designsubcontractnodeVOList = BeanMapper.mapList((Iterable)list, DesignsubcontractnodeVO.class);
        for (int i = 0; i < designsubcontractnodeVOList.size(); ++i) {
            DesignsubcontractnodeVO designsubcontractnodeVO = (DesignsubcontractnodeVO)((Object)designsubcontractnodeVOList.get(i));
            designsubcontractnodeVO.setSort(String.valueOf(i + 1));
            String billStateStr = designsubcontractnodeVO.getBillState().toString();
            if (billStateStr == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            designsubcontractnodeVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", designsubcontractnodeVOList);
        ExcelExport.getInstance().export("designsubcontractnodeList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDesignsubcontractnodeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DesignsubcontractnodeVO>> refDesignsubcontractnodeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DesignsubcontractnodedetailVO>> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            DesignsubcontractnodeEntity entity = (DesignsubcontractnodeEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", this.getPastTotalData(contractId, currentDate));
    }

    private List<DesignsubcontractnodedetailVO> getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract", (Object)contractId);
        queryWrapperTotal.eq((Object)"bill_state", (Object)3);
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List list = this.service.list((Wrapper)queryWrapperTotal);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"mid", (Object)((DesignsubcontractnodeEntity)((Object)list.get(0))).getId());
        List entityList = this.detailService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)entityList)) {
            throw new RuntimeException("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<DesignsubcontractnodedetailVO> voList = new ArrayList<DesignsubcontractnodedetailVO>();
        for (DesignsubcontractnodedetailEntity entity : entityList) {
            DesignsubcontractnodedetailVO vo = new DesignsubcontractnodedetailVO();
            vo.setCompleteLastAudit(entity.getCompleteCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getCompleteCumulativeAudit());
            vo.setExTaxUnitLastAudit(entity.getExTaxUnitLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxUnitLastAudit());
            vo.setInTaxUnitLastAudit(entity.getInTaxUnitLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxUnitLastAudit());
            vo.setExTaxTotalLastAudit(entity.getExTaxTotalLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxTotalLastAudit());
            vo.setInTaxTotalLastAudit(entity.getInTaxTotalLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxTotalLastAudit());
            vo.setCompleteCumulativeAudit(entity.getCompleteCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getCompleteCumulativeAudit());
            vo.setExTaxUnitCumulativeAudit(entity.getExTaxUnitCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxUnitCumulativeAudit());
            vo.setInTaxUnitCumulativeAudit(entity.getInTaxUnitCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxUnitCumulativeAudit());
            vo.setExTaxTotalCumulativeAudit(entity.getExTaxTotalCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxTotalCumulativeAudit());
            vo.setInTaxTotalCumulativeAudit(entity.getInTaxTotalCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxTotalCumulativeAudit());
            vo.setContractId(contractId);
            vo.setProjectName(entity.getProjectName());
            voList.add(vo);
        }
        return voList;
    }
}

