/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"engineermeasurement"})
public class EngineermeasurementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IEngineermeasurementService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> saveOrUpdate(@RequestBody EngineermeasurementVO saveorUpdateVO) {
        EngineermeasurementEntity entity = (EngineermeasurementEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), EngineermeasurementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
            queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u5de5\u7a0b\u8ba1\u91cf\u53f0\u8d26\u5355\u636e\"!");
            }
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (saveorUpdateVO.getCreateTime() != null) {
            currentDate = saveorUpdateVO.getCreateTime();
        }
        EngineermeasurementVO pastVo = this.getPastTotalData(saveorUpdateVO.getContractId(), currentDate);
        BigDecimal cumulativeCompleted = saveorUpdateVO.getActualCompletedThisPeriod().add(pastVo.getCumulativeCompleted());
        BigDecimal cumulativeBatch = saveorUpdateVO.getCurrentBatch().add(pastVo.getCumulativeBatch());
        BigDecimal cumulativeCollection = saveorUpdateVO.getCurrentCollection().add(pastVo.getCumulativeCollection());
        entity.setCumulativeCompleted(cumulativeCompleted);
        entity.setCumulativeBatch(cumulativeBatch);
        entity.setCumulativeCollection(cumulativeCollection);
        BigDecimal cumulativeCompletedProportion = cumulativeCompleted.divide(saveorUpdateVO.getContractAmount(), 8, 4);
        cumulativeCompletedProportion = cumulativeCompletedProportion.multiply(new BigDecimal(100));
        entity.setCumulativeCompletedProportion(cumulativeCompletedProportion);
        this.service.saveOrUpdate((Object)entity, false);
        EngineermeasurementVO vo = (EngineermeasurementVO)((Object)BeanMapper.map((Object)((Object)entity), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> queryDetail(Long id) {
        EngineermeasurementEntity entity = (EngineermeasurementEntity)((Object)this.service.selectById(id));
        EngineermeasurementVO vo = (EngineermeasurementVO)((Object)BeanMapper.map((Object)((Object)entity), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngineermeasurementVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List engineermeasurementVOList = BeanMapper.mapList((Iterable)list, EngineermeasurementVO.class);
        for (int i = 0; i < engineermeasurementVOList.size(); ++i) {
            String billStateStr;
            EngineermeasurementVO engineermeasurementVO = (EngineermeasurementVO)((Object)engineermeasurementVOList.get(i));
            engineermeasurementVO.setSort(String.valueOf(i + 1));
            if (engineermeasurementVO.getReportingTime() != null) {
                engineermeasurementVO.setReportingTimeShow(DateUtils.dateSimple2(engineermeasurementVO.getReportingTime()));
            }
            if ((billStateStr = engineermeasurementVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            engineermeasurementVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", engineermeasurementVOList);
        ExcelExport.getInstance().export("EngineermeasurementMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEngineermeasurementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> refEngineermeasurementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            EngineermeasurementEntity entity = (EngineermeasurementEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate)));
    }

    private EngineermeasurementVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        BigDecimal cumulativeCompleted = new BigDecimal(0);
        BigDecimal cumulativeBatch = new BigDecimal(0);
        BigDecimal cumulativeCollection = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                EngineermeasurementEntity engineermeasurementEntity = (EngineermeasurementEntity)((Object)proTotal.get(i));
                cumulativeCompleted = cumulativeCompleted.add(engineermeasurementEntity.getActualCompletedThisPeriod());
                cumulativeBatch = cumulativeBatch.add(engineermeasurementEntity.getCurrentBatch());
                cumulativeCollection = cumulativeCollection.add(engineermeasurementEntity.getCurrentCollection());
            }
        }
        EngineermeasurementVO vo = new EngineermeasurementVO();
        vo.setCumulativeCompleted(cumulativeCompleted);
        vo.setCumulativeBatch(cumulativeBatch);
        vo.setCumulativeCollection(cumulativeCollection);
        vo.setContractId(contractId);
        return vo;
    }
}

