/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"mechanicallease"})
public class MechanicalleaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMechanicalleaseService service;
    @Autowired
    private IMechanicalleasedetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> saveOrUpdate(@RequestBody MechanicalleaseVO saveorUpdateVO) {
        MechanicalleaseEntity entity = (MechanicalleaseEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), MechanicalleaseEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                Date currentDate = new Date(System.currentTimeMillis());
                if (saveorUpdateVO.getCreateTime() != null) {
                    currentDate = saveorUpdateVO.getCreateTime();
                }
                MechanicalleaseVO data = this.getPastTotalData(saveorUpdateVO.getContractId(), currentDate);
                entity.setExTaxCumulative(data.getExTaxCumulative().add(saveorUpdateVO.getExTaxThisMonthTotal()));
                entity.setInTaxCumulative(data.getInTaxCumulative().add(saveorUpdateVO.getInTaxThisMonthTotal()));
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MechanicalleaseVO vo = (MechanicalleaseVO)((Object)BeanMapper.map((Object)((Object)entity), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> queryDetail(Long id) {
        MechanicalleaseEntity entity = (MechanicalleaseEntity)((Object)this.service.selectById(id));
        MechanicalleaseVO vo = (MechanicalleaseVO)((Object)BeanMapper.map((Object)((Object)entity), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MechanicalleaseVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List mechanicalleaseVOList = BeanMapper.mapList((Iterable)list, MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); ++i) {
            String billStateStr;
            MechanicalleaseVO mechanicalleaseVO = (MechanicalleaseVO)((Object)mechanicalleaseVOList.get(i));
            mechanicalleaseVO.setSort(String.valueOf(i + 1));
            if (mechanicalleaseVO.getSettlementTime() != null) {
                mechanicalleaseVO.setSettlementTime((Date)DateUtil.date((Date)mechanicalleaseVO.getSettlementTime()));
            }
            if (mechanicalleaseVO.getBillingStartTime() != null) {
                mechanicalleaseVO.setBillingStartTime((Date)DateUtil.date((Date)mechanicalleaseVO.getBillingStartTime()));
            }
            if (mechanicalleaseVO.getBillingEndTime() != null) {
                mechanicalleaseVO.setBillingEndTime((Date)DateUtil.date((Date)mechanicalleaseVO.getBillingEndTime()));
            }
            if ((billStateStr = mechanicalleaseVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            mechanicalleaseVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", mechanicalleaseVOList);
        ExcelExport.getInstance().export("mechanicalleaseList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMechanicalleaseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> refMechanicalleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List mechanicalleaseVOList = BeanMapper.mapList((Iterable)page.getRecords(), MechanicalleaseVO.class);
        for (MechanicalleaseVO record : mechanicalleaseVOList) {
            Long mid = record.getId();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"mid", (Object)mid);
            List mechanicalleasedetailEntityList = this.detailService.list((Wrapper)wrapper);
            if (!CollectionUtil.isNotEmpty((Collection)mechanicalleasedetailEntityList)) continue;
            record.setMechanicalleasedetailEntities(BeanMapper.mapList((Iterable)mechanicalleasedetailEntityList, MechanicalleasedetailVO.class));
        }
        pageData.setRecords(mechanicalleaseVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            MechanicalleaseEntity mechanicalleaseEntity = (MechanicalleaseEntity)((Object)this.service.selectById(id));
            currentDate = mechanicalleaseEntity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate)));
    }

    private MechanicalleaseVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"bill_state", (Object)3);
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List list = this.service.list((Wrapper)queryWrapperTotal);
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        String projectCode = "";
        Long supplierId = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MechanicalleaseEntity entity = (MechanicalleaseEntity)((Object)list.get(i));
                exTaxCumulative = exTaxCumulative.add(entity.getExTaxCumulative() == null ? BigDecimal.valueOf(0L) : entity.getExTaxCumulative());
                inTaxCumulative = inTaxCumulative.add(entity.getInTaxCumulative() == null ? BigDecimal.valueOf(0L) : entity.getInTaxCumulative());
            }
            projectCode = ((MechanicalleaseEntity)((Object)list.get(0))).getProjectCode();
            supplierId = ((MechanicalleaseEntity)((Object)list.get(0))).getSupplierId();
        }
        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(exTaxCumulative);
        vo.setInTaxCumulative(inTaxCumulative);
        vo.setProjectCode(projectCode);
        vo.setSupplierId(supplierId);
        vo.setContractId(contractId);
        return vo;
    }
}

