/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchasesettlement"})
public class PurchasesettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPurchasesettlementService service;
    @Autowired
    private IPurchasesettlementdetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> saveOrUpdate(@RequestBody PurchasesettlementVO saveorUpdateVO) {
        List<PurchasesettlementdetailEntity> detailEntities;
        PurchasesettlementEntity entity = (PurchasesettlementEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), PurchasesettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
            queryWrapper.in((Object)"bill_state", new Object[]{0, 2, 4, 5});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355\"!");
            }
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
            queryWrapper.eq((Object)"occurrence_time", (Object)entity.getOccurrenceTime());
            List list = this.service.list((Wrapper)queryWrapper);
            if (pro != null && list.size() > 0) {
                throw new BusinessException("\u76f8\u540c\u5408\u540c\u7684\u53d1\u751f\u65e5\u671f\u4e0d\u5141\u8bb8\u91cd\u590d!");
            }
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BigDecimal settlementTotal = new BigDecimal(0);
        BigDecimal taxSettlementTotal = new BigDecimal(0);
        QueryWrapper detailQueryWrapper = new QueryWrapper();
        detailQueryWrapper.eq((Object)"contract_id", (Object)saveorUpdateVO.getContractId());
        detailQueryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        detailQueryWrapper.eq((Object)"bill_code", (Object)saveorUpdateVO.getMaterialCode());
        List list = this.detailService.list((Wrapper)detailQueryWrapper);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesettlementdetailEntity detailEntity = (PurchasesettlementdetailEntity)((Object)list.get(i));
                settlementTotal = settlementTotal.add(detailEntity.getSettlementAmount());
                taxSettlementTotal = taxSettlementTotal.add(detailEntity.getTaxSettlementAmount());
            }
        }
        if ((detailEntities = entity.getPurchasesettlementdetailEntities()) != null && detailEntities.size() > 0) {
            for (int i = 0; i < detailEntities.size(); ++i) {
                PurchasesettlementdetailEntity purchasesettlementdetailEntity = detailEntities.get(i);
                purchasesettlementdetailEntity.setSettlementTotal(settlementTotal);
                purchasesettlementdetailEntity.setTaxSettlementTotal(taxSettlementTotal);
            }
        }
        entity.setPurchasesettlementdetailEntities(detailEntities);
        entity.setIsReference(0);
        this.service.saveOrUpdate((Object)entity, false);
        PurchasesettlementVO vo = (PurchasesettlementVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasesettlementVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> queryDetail(Long id) {
        PurchasesettlementEntity entity = (PurchasesettlementEntity)((Object)this.service.selectById(id));
        PurchasesettlementVO vo = (PurchasesettlementVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasesettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasesettlementVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasesettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Purchasesettlement-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchasesettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> refPurchasesettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasesettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            PurchasesettlementEntity entity = (PurchasesettlementEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate)));
    }

    private PurchasesettlementVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"bill_state", (Object)3);
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                PurchasesettlementEntity purchasesettlementEntity = (PurchasesettlementEntity)((Object)proTotal.get(i));
                occurrenceTotal = occurrenceTotal.add(purchasesettlementEntity.getMonthlyTotal());
                taxOccurrenceTotal = taxOccurrenceTotal.add(purchasesettlementEntity.getTaxMonthlyTotal());
            }
        }
        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);
        vo.setContractId(contractId);
        return vo;
    }
}

