/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesummaryEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.service.IPurchasesummaryService;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesummaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchasesummary"})
public class PurchasesummaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPurchasesummaryService service;
    @Autowired
    private IPurchasesettlementService purchasesettlementService;
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> saveOrUpdate(@RequestBody PurchasesummaryVO saveorUpdateVO) {
        List<String> referenceIdList;
        PurchasesummaryEntity entity = (PurchasesummaryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), PurchasesummaryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.in((Object)"bill_state", new Object[]{0, 2, 4, 5});
        List pro = this.service.list((Wrapper)queryWrapper);
        if (pro != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u6708\u5ea6\u91c7\u8d2d\u7ed3\u7b97\u6c47\u603b\u5355\"!");
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"statistical_time", (Object)entity.getStatisticalTime());
        List proDate = this.service.list((Wrapper)queryWrapper1);
        if (proDate != null && proDate.size() > 0) {
            throw new BusinessException(entity.getProjectName() + "\u9879\u76ee\u8be5\u6708\u4efd\u5355\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa!");
        }
        if (entity.getId() != null && (referenceIdList = saveorUpdateVO.getReferenceIdList()) != null && referenceIdList.size() > 0) {
            for (int i = 0; i < referenceIdList.size(); ++i) {
                QueryWrapper referenceWrapper = new QueryWrapper();
                PurchasesettlementEntity referenceEntities = (PurchasesettlementEntity)((Object)this.purchasesettlementService.selectById((Serializable)((Object)referenceIdList.get(i))));
                if (referenceEntities == null) continue;
                referenceEntities.setIsReference(1);
                this.purchasesettlementService.saveOrUpdate((Object)referenceEntities);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PurchasesummaryVO vo = (PurchasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> queryDetail(Long id) {
        PurchasesummaryEntity entity = (PurchasesummaryEntity)((Object)this.service.selectById(id));
        PurchasesummaryVO vo = (PurchasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasesummaryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasesummaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Purchasesummary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchasesummaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasesummaryVO>> refPurchasesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPurchasesettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> refPurchasesettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("isReference", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.purchasesettlementService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), PurchasesettlementVO.class);
        if (voList != null && voList.size() > 0) {
            for (int i = 0; i < voList.size(); ++i) {
                PurchasesettlementVO vo = (PurchasesettlementVO)((Object)voList.get(i));
                vo.setSort(String.valueOf(i + 1));
                Long id = vo.getId();
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)id);
                detailWrapper.eq((Object)"dr", (Object)0);
                List entityList = this.purchasesettlementdetailService.list((Wrapper)detailWrapper);
                if (entityList == null || entityList.size() <= 0) continue;
                List detailList = BeanMapper.mapList((Iterable)entityList, PurchasesettlementdetailVO.class);
                vo.setPurchasesettlementdetailEntities(detailList);
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> pastData(Long id, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            PurchasesummaryEntity entity = (PurchasesummaryEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.lt((Object)"create_time", (Object)currentDate);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        List list = this.service.list((Wrapper)wrapper);
        BigDecimal settlementTotal = new BigDecimal(0);
        BigDecimal taxSettlementTotal = new BigDecimal(0);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesummaryEntity purchasesummaryEntity = (PurchasesummaryEntity)((Object)list.get(i));
                settlementTotal = settlementTotal.add(purchasesummaryEntity.getSettlementAmount());
                taxSettlementTotal = settlementTotal.add(purchasesummaryEntity.getTaxSettlementAmount());
            }
        }
        PurchasesummaryVO vo = new PurchasesummaryVO();
        vo.setSettlementTotal(settlementTotal);
        vo.setTaxSettlementTotal(taxSettlementTotal);
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

