/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"interimsettlementExport"})
public class ExcelInterimsettlementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInterimsettlementdetailService interimsettlementdetailService;

    @RequestMapping(value={"/downloadInterimsettlementdetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"interimsettlementdetail-import.xlsx", (String)"\u9879\u76ee\u671f\u4e2d\u7ed3\u7b97\u53f0\u8d26\u6a21\u677f");
    }

    @RequestMapping(value={"/excelInterimsettlement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<InterimsettlementdetailVO> successList = new ArrayList<InterimsettlementdetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        BigDecimal newApproval = new BigDecimal(0.0);
        BigDecimal newRetention = new BigDecimal(0.0);
        BigDecimal newActual = new BigDecimal(0.0);
        BigDecimal newUncollected = new BigDecimal(0.0);
        BigDecimal newReceivable = new BigDecimal(0.0);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"bill_state", (Object)3);
        List list = this.interimsettlementdetailService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            throw new RuntimeException("\u6682\u65e0\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e");
        }
        for (InterimsettlementdetailEntity entity : list) {
            if (entity.getCurrentApproval() != null) {
                newApproval.add(entity.getCurrentApproval());
            }
            if (entity.getCurrentReceivable() != null) {
                newReceivable.add(entity.getCurrentReceivable());
            }
            if (entity.getCurrentActual() != null) {
                newRetention.add(entity.getCurrentRetention());
            }
            if (entity.getCurrentActual() != null) {
                newActual.add(entity.getCurrentActual());
            }
            if (entity.getCurrentUncollected() == null) continue;
            newUncollected.add(entity.getCurrentUncollected());
        }
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                InterimsettlementdetailVO interimsettlementVO = new InterimsettlementdetailVO();
                List datas = (List)result.get(i);
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    newApproval.add(new BigDecimal(Double.valueOf((String)datas.get(4))));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    newReceivable.add(new BigDecimal(Double.valueOf((String)datas.get(6))));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    newRetention.add(new BigDecimal(Double.valueOf((String)datas.get(7))));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    newActual.add(new BigDecimal(Double.valueOf((String)datas.get(8))));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                    newUncollected.add(new BigDecimal(Double.valueOf((String)datas.get(9))));
                }
                interimsettlementVO.setId(IdWorker.getId());
                interimsettlementVO.setIssueNumber(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) ? String.valueOf(datas.get(0)) : null);
                interimsettlementVO.setCompletionMonth(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                interimsettlementVO.setApplicationNo(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? String.valueOf(datas.get(2)) : null);
                interimsettlementVO.setApplicationAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                interimsettlementVO.setCurrentApproval(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                interimsettlementVO.setCumulativeApproval(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? newApproval : null);
                interimsettlementVO.setIncome(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                interimsettlementVO.setCurrentReceivable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                interimsettlementVO.setCumulativeReceivable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? newReceivable : null);
                interimsettlementVO.setCurrentRetention(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                interimsettlementVO.setCumulativeRetention(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? newRetention : null);
                interimsettlementVO.setCurrentActual(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                interimsettlementVO.setCumulativeActual(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? newActual : null);
                interimsettlementVO.setCurrentUncollected(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                interimsettlementVO.setCumulativeUncollected(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? newUncollected : null);
                interimsettlementVO.setActualCollection(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? DateUtils.Date((String)datas.get(10)) : null);
                interimsettlementVO.setCashFlow(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? String.valueOf(datas.get(11)) : null);
                interimsettlementVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? String.valueOf(datas.get(12)) : null);
                successList.add(interimsettlementVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportInterimsettlementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody InterimsettlementVO detailVo, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)detailVo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.interimsettlementdetailService.list((Wrapper)queryWrapper);
        List interimsettlementdetailVOList = BeanMapper.mapList((Iterable)list, InterimsettlementdetailVO.class);
        if (interimsettlementdetailVOList != null && interimsettlementdetailVOList.size() > 0) {
            for (int i = 0; i < interimsettlementdetailVOList.size(); ++i) {
                InterimsettlementdetailVO interimsettlementdetailVO = (InterimsettlementdetailVO)((Object)interimsettlementdetailVOList.get(i));
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() == null) continue;
                interimsettlementdetailVO.setActualCollectionShow(DateUtils.dateSimple(interimsettlementdetailVO.getActualCollection()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", interimsettlementdetailVOList);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportInterimsettlementdetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<InterimsettlementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                InterimsettlementdetailVO interimsettlementdetailVO = list.get(i);
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() == null) continue;
                interimsettlementdetailVO.setActualCollection((Date)DateUtil.date((Date)interimsettlementdetailVO.getActualCollection()));
            }
        }
        HashMap<String, List<InterimsettlementdetailVO>> beans = new HashMap<String, List<InterimsettlementdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }
}

