/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IPurchasesummarydetatilService;
import com.ejianc.business.middlemeasurement.vo.PurchasesummaryVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesummarydetatilVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"purchasesummaryExport"})
public class ExcelPurchasesummaryController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchasesummarydetatilService purchasesummarydetatilService;

    @RequestMapping(value={"/downloadPurchasesummary"})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"purchasesummarydetail-import.xlsx", (String)"\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u6c47\u603b\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportPurchasesummary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PurchasesummarydetatilVO> successList = new ArrayList<PurchasesummarydetatilVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PurchasesummarydetatilVO purchasesummarydetatilVO = new PurchasesummarydetatilVO();
                purchasesummarydetatilVO.setId(IdWorker.getId());
                purchasesummarydetatilVO.setContractName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) ? (String)datas.get(0) : null);
                purchasesummarydetatilVO.setCategoryCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                purchasesummarydetatilVO.setMaterialCategory(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                purchasesummarydetatilVO.setSupplierName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                purchasesummarydetatilVO.setSettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                purchasesummarydetatilVO.setTaxSettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                purchasesummarydetatilVO.setSettlementTotal(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                purchasesummarydetatilVO.setTaxSettlementTotal(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                purchasesummarydetatilVO.setPaymentProportion(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                purchasesummarydetatilVO.setCumulativePayable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                purchasesummarydetatilVO.setCumulativePayment(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                purchasesummarydetatilVO.setContacts(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? (String)datas.get(11) : null);
                purchasesummarydetatilVO.setContactsWay(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? (String)datas.get(12) : null);
                purchasesummarydetatilVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? (String)datas.get(13) : null);
                successList.add(purchasesummarydetatilVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportPurchasesummaryFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesummaryVO purchasesummaryVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)purchasesummaryVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.purchasesummarydetatilService.list((Wrapper)queryWrapper);
        List purchasesummarydetatilVOList = BeanMapper.mapList((Iterable)list, PurchasesummarydetatilVO.class);
        if (purchasesummarydetatilVOList != null && purchasesummarydetatilVOList.size() > 0) {
            for (int i = 0; i < purchasesummarydetatilVOList.size(); ++i) {
                PurchasesummarydetatilVO purchasesummarydetatilVO = (PurchasesummarydetatilVO)((Object)purchasesummarydetatilVOList.get(i));
                purchasesummarydetatilVO.setSotr(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", purchasesummarydetatilVOList);
        ExcelExport.getInstance().export("purchasesummarydetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportPurchasesummaryFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesummarydetatilVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesummarydetatilVO purchasesummarydetatilVO = list.get(i);
                purchasesummarydetatilVO.setSotr(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<PurchasesummarydetatilVO>> beans = new HashMap<String, List<PurchasesummarydetatilVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesummarydetail-export.xlsx", beans, response);
    }
}

