package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.ICapitalinflowsService;
import com.ejianc.business.middlemeasurement.vo.CapitalinflowsVO;

/**
 * 资金流入
 *
 * @author generator
 */
@Controller
@RequestMapping("capitalinflows")
public class CapitalinflowsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICapitalinflowsService service;

    @Autowired
    private IEngineermeasurementService engineermeasurementService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CapitalinflowsVO> saveOrUpdate(@RequestBody CapitalinflowsVO saveorUpdateVO) {
        CapitalinflowsEntity entity = BeanMapper.map(saveorUpdateVO, CapitalinflowsEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            //创建条件构造器
            QueryWrapper<CapitalinflowsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.notIn("bill_state", 1, 3);//1直审的已提交 3审批通过 ne（不等于） notIn
            List<CapitalinflowsEntity> pro = service.list(queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("同一项目只能存在一份自由态、审批中、审批驳回的\"资金流入\"!");
            }

            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        CapitalinflowsVO vo = BeanMapper.map(entity, CapitalinflowsVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CapitalinflowsVO> queryDetail(Long id) {
        CapitalinflowsEntity entity = service.selectById(id);
        CapitalinflowsVO vo = BeanMapper.map(entity, CapitalinflowsVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CapitalinflowsVO> vos) {
        service.removeByIds(vos.stream().map(CapitalinflowsVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CapitalinflowsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        /*param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));*/

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<CapitalinflowsEntity> page = service.queryPage(param, false);
        IPage<CapitalinflowsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CapitalinflowsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CapitalinflowsEntity> list = service.queryList(param);
        //时间转换
        List<CapitalinflowsVO> capitalinflowsVOList = BeanMapper.mapList(list, CapitalinflowsVO.class);
        for (int i = 0; i < capitalinflowsVOList.size(); i++) {
            CapitalinflowsVO capitalinflowsVO = capitalinflowsVOList.get(i);
            capitalinflowsVO.setSort(String.valueOf(i + 1));
            if (capitalinflowsVO.getDeadline() != null) {
                capitalinflowsVO.setDeadline(DateUtil.date(capitalinflowsVO.getDeadline()));
            }
            String billStateStr = capitalinflowsVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }
                capitalinflowsVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", capitalinflowsVOList);
        ExcelExport.getInstance().export("capitalinflowsList-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCapitalinflowsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CapitalinflowsVO>> refCapitalinflowsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CapitalinflowsEntity> page = service.queryPage(param, false);
        IPage<CapitalinflowsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CapitalinflowsVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param
     * @Description 自动任务执行--每月1号00：00：00执行，保存当前数据快照
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveSnapshotData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveSnapshotData() {
        return service.saveSnapshotData();
    }

    /**
     * @Description saveOrUpdate 手动保存当前的数据到es
     */
    @RequestMapping(value = "/saveESData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveESData() {
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        return service.saveESData("资金流入统计报表（手动）" + curDate);
    }

    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CapitalinflowsVO>> queryReportList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        return CommonResponse.success(service.queryEsByPage(param));
    }


    /**
     * @param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/esExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse esExcelExport(HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
       /* List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);*/
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /*param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));*/
        QueryParam param = new QueryParam();
        IPage<CapitalinflowsVO> page = service.queryEsByPage(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", page.getRecords());
        ExcelExport.getInstance().export("CapitalinflowsReport-export.xlsx", beans, response);
        return CommonResponse.success();
    }

    /**
     * 查询所有的ES快照版本
     */
    @RequestMapping(value = "/queryEsSnap", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryEsSnap() {
        List<String> list = service.queryEsSnap();
        return CommonResponse.success(list);
    }


    /**
     * @param projectId
     * @Description 查询往期
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CapitalinflowsVO> pastData(Long projectId, Date deadline) {
        Date deadlineRes = deadline;

        if (deadline == null) {
            deadlineRes = new Date(System.currentTimeMillis());
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(projectId, deadlineRes));
    }

    /**
     * 获取往期审批通过的工程计量台账合计数据
     *
     * @param projectId 项目id
     * @param deadline  截至时间
     *                  <p>
     *                  根据项目查找，审批通过，发生时间最近的“工程计量台账”，
     *                  经营性债权 = 表头的“累计批量” - “累计收款金额"，
     *                  项目下有多个合同，则为多个合同计算得出的"经营性债权"相加
     */
    private CapitalinflowsVO getPastTotalData(Long projectId, Date deadline) {
        //创建条件构造器
        QueryWrapper<EngineermeasurementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("project_id", projectId);
        queryWrapperTotal.in("bill_state", 1, 3);//审批通过
        queryWrapperTotal.lt("create_time", deadline);//往期 lt（小于）
        queryWrapperTotal.orderByDesc("reporting_time");//报量时间
        queryWrapperTotal.groupBy("contract_id");//合同

        List<EngineermeasurementEntity> proTotal = engineermeasurementService.list(queryWrapperTotal);
        //已收款金额
        BigDecimal receivedPayment = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); i++) {
                EngineermeasurementEntity engineermeasurementEntity = proTotal.get(i);
                //累计收款金额
                BigDecimal cumulativeCollection = engineermeasurementEntity.getCumulativeCollection();
                receivedPayment = receivedPayment.add(cumulativeCollection);
            }
        }

        CapitalinflowsVO vo = new CapitalinflowsVO();
        vo.setReceivedPayment(receivedPayment);
        vo.setProjectId(projectId);

        return vo;
    }
}
