package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.bean.MonthlyapprovalEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodeVO;

/**
 * 设计分包节点报量申请
 *
 * @author generator
 */
@Controller
@RequestMapping("designsubcontractnode")
public class DesignsubcontractnodeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDesignsubcontractnodeService service;

    @Autowired
    private IDesignsubcontractnodedetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DesignsubcontractnodeVO> saveOrUpdate(@RequestBody DesignsubcontractnodeVO saveorUpdateVO) {
        DesignsubcontractnodeEntity entity = BeanMapper.map(saveorUpdateVO, DesignsubcontractnodeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DesignsubcontractnodeVO vo = BeanMapper.map(entity, DesignsubcontractnodeVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DesignsubcontractnodeVO> queryDetail(Long id) {
        DesignsubcontractnodeEntity entity = service.selectById(id);
        DesignsubcontractnodeVO vo = BeanMapper.map(entity, DesignsubcontractnodeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DesignsubcontractnodeVO> vos) {
        service.removeByIds(vos.stream().map(DesignsubcontractnodeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DesignsubcontractnodeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        /*param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));*/

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<DesignsubcontractnodeEntity> page = service.queryPage(param, false);
        IPage<DesignsubcontractnodeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DesignsubcontractnodeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DesignsubcontractnodeEntity> list = service.queryList(param);
        //时间转换
        List<DesignsubcontractnodeVO> designsubcontractnodeVOList = BeanMapper.mapList(list, DesignsubcontractnodeVO.class);
        for (int i = 0; i < designsubcontractnodeVOList.size(); i++) {
            DesignsubcontractnodeVO designsubcontractnodeVO = designsubcontractnodeVOList.get(i);
            designsubcontractnodeVO.setSort(String.valueOf(i + 1));
            String billStateStr = designsubcontractnodeVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }
                designsubcontractnodeVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", designsubcontractnodeVOList);
        ExcelExport.getInstance().export("designsubcontractnodeList-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDesignsubcontractnodeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DesignsubcontractnodeVO>> refDesignsubcontractnodeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                       String condition,
                                                                                       String searchObject,
                                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DesignsubcontractnodeEntity> page = service.queryPage(param, false);
        IPage<DesignsubcontractnodeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DesignsubcontractnodeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DesignsubcontractnodedetailVO>> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            DesignsubcontractnodeEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private List<DesignsubcontractnodedetailVO> getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器-子表数据筛选
        QueryWrapper<DesignsubcontractnodeEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract", contractId);
        queryWrapperTotal.eq("bill_state", 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<DesignsubcontractnodeEntity> list = service.list(queryWrapperTotal);

        //用来查询所选合同金额--主表
        QueryWrapper<DesignsubcontractnodedetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("mid", list.get(0).getId());
        List<DesignsubcontractnodedetailEntity> entityList = detailService.list(wrapper);
        if (CollectionUtil.isEmpty(entityList)) {
            throw new RuntimeException("查询到的数据为空");
        }
        ArrayList<DesignsubcontractnodedetailVO> voList = new ArrayList<>();
        for (DesignsubcontractnodedetailEntity entity : entityList) {
            DesignsubcontractnodedetailVO vo = new DesignsubcontractnodedetailVO();
            vo.setCompleteLastAudit(entity.getCompleteCumulativeAudit() == null ? BigDecimal.valueOf(0) : entity.getCompleteCumulativeAudit());
            vo.setExTaxUnitLastAudit(entity.getExTaxUnitLastAudit() == null ? BigDecimal.valueOf(0) : entity.getExTaxUnitLastAudit());
            vo.setInTaxUnitLastAudit(entity.getInTaxUnitLastAudit() == null ? BigDecimal.valueOf(0) : entity.getInTaxUnitLastAudit());
            vo.setExTaxTotalLastAudit(entity.getExTaxTotalLastAudit() == null ? BigDecimal.valueOf(0) : entity.getExTaxTotalLastAudit());
            vo.setInTaxTotalLastAudit(entity.getInTaxTotalLastAudit() == null ? BigDecimal.valueOf(0) : entity.getInTaxTotalLastAudit());
            vo.setCompleteCumulativeAudit(entity.getCompleteCumulativeAudit() == null ? BigDecimal.valueOf(0) : entity.getCompleteCumulativeAudit());
            vo.setExTaxUnitCumulativeAudit(entity.getExTaxUnitCumulativeAudit() == null ? BigDecimal.valueOf(0) : entity.getExTaxUnitCumulativeAudit());
            vo.setInTaxUnitCumulativeAudit(entity.getInTaxUnitCumulativeAudit() == null ? BigDecimal.valueOf(0) : entity.getInTaxUnitCumulativeAudit());
            vo.setExTaxTotalCumulativeAudit(entity.getExTaxTotalCumulativeAudit() == null ? BigDecimal.valueOf(0) : entity.getExTaxTotalCumulativeAudit());
            vo.setInTaxTotalCumulativeAudit(entity.getInTaxTotalCumulativeAudit() == null ? BigDecimal.valueOf(0) : entity.getInTaxTotalCumulativeAudit());
            vo.setContractId(contractId);
            vo.setProjectName(entity.getProjectName());
            voList.add(vo);
        }
        return voList;
    }
}
