package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.bean.MonthlyapprovalEntity;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;

/**
 * 工程计量台账
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("engineermeasurement")
public class EngineermeasurementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IEngineermeasurementService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> saveOrUpdate(@RequestBody EngineermeasurementVO saveorUpdateVO) {
    	EngineermeasurementEntity entity = BeanMapper.map(saveorUpdateVO, EngineermeasurementEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());

            //1.校验（同一合同，如有未审批通过的单据，不允许新增）
            //创建条件构造器
            QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.notIn("bill_state", 1, 3);//1直审的已提交 3审批通过 ne（不等于） notIn
            List<EngineermeasurementEntity> pro = service.list(queryWrapper);
            if(pro != null && pro.size() > 0){
                throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"工程计量台账单据\"!");
            }

            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //2.累计（包含本期）
        Date currentDate = new Date(System.currentTimeMillis());
        if(saveorUpdateVO.getCreateTime() != null){
            currentDate = saveorUpdateVO.getCreateTime();
        }
        //获取往期
        EngineermeasurementVO pastVo = getPastTotalData(saveorUpdateVO.getContractId(), currentDate);
        //本期 + 往期
        BigDecimal cumulativeCompleted = saveorUpdateVO.getActualCompletedThisPeriod().add(pastVo.getCumulativeCompleted());
        BigDecimal cumulativeBatch = saveorUpdateVO.getCurrentBatch().add(pastVo.getCumulativeBatch());
        BigDecimal cumulativeCollection = saveorUpdateVO.getCurrentCollection().add(pastVo.getCumulativeCollection());

        entity.setCumulativeCompleted(cumulativeCompleted);
        entity.setCumulativeBatch(cumulativeBatch);
        entity.setCumulativeCollection(cumulativeCollection);

        //累计完成比例：累计实际完成量/合同额
        BigDecimal cumulativeCompletedProportion = cumulativeCompleted.divide(saveorUpdateVO.getContractAmount(), 8, BigDecimal.ROUND_HALF_UP);
        cumulativeCompletedProportion = cumulativeCompletedProportion.multiply(new BigDecimal(100));
        entity.setCumulativeCompletedProportion(cumulativeCompletedProportion);

    	service.saveOrUpdate(entity, false);
    	EngineermeasurementVO vo = BeanMapper.map(entity, EngineermeasurementVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> queryDetail(Long id) {
    	EngineermeasurementEntity entity = service.selectById(id);
    	EngineermeasurementVO vo = BeanMapper.map(entity, EngineermeasurementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngineermeasurementVO> vos) {
        service.removeByIds(vos.stream().map(EngineermeasurementVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EngineermeasurementEntity> page = service.queryPage(param,false);
        IPage<EngineermeasurementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineermeasurementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EngineermeasurementEntity> list = service.queryList(param);
        //时间转换
        List<EngineermeasurementVO> engineermeasurementVOList = BeanMapper.mapList(list, EngineermeasurementVO.class);
        for (int i = 0; i < engineermeasurementVOList.size(); i++) {
            EngineermeasurementVO engineermeasurementVO = engineermeasurementVOList.get(i);
            engineermeasurementVO.setSort(String.valueOf(i+1));
            if (engineermeasurementVO.getReportingTime()!=null){
                engineermeasurementVO.setReportingTimeShow(DateUtils.dateSimple2(engineermeasurementVO.getReportingTime()));
            }

            String billStateStr = engineermeasurementVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                engineermeasurementVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", engineermeasurementVOList);
        ExcelExport.getInstance().export("EngineermeasurementMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refEngineermeasurementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> refEngineermeasurementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EngineermeasurementEntity> page = service.queryPage(param,false);
        IPage<EngineermeasurementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineermeasurementVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description  查询往期
     * @param contractId
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if(id != null && "".equals(id)){//更新
            EngineermeasurementEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     */
    private EngineermeasurementVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器
        QueryWrapper<EngineermeasurementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<EngineermeasurementEntity> proTotal = service.list(queryWrapperTotal);

        //累计实际完成量
        BigDecimal cumulativeCompleted = new BigDecimal(0);
        //累计批量
        BigDecimal cumulativeBatch = new BigDecimal(0);
        //累计收款金额
        BigDecimal cumulativeCollection = new BigDecimal(0);
        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                EngineermeasurementEntity engineermeasurementEntity = proTotal.get(i);
                cumulativeCompleted = cumulativeCompleted.add(engineermeasurementEntity.getActualCompletedThisPeriod());
                cumulativeBatch = cumulativeBatch.add(engineermeasurementEntity.getCurrentBatch());
                cumulativeCollection = cumulativeCollection.add(engineermeasurementEntity.getCurrentCollection());
            }
        }

        EngineermeasurementVO vo = new EngineermeasurementVO();
        vo.setCumulativeCompleted(cumulativeCompleted);
        vo.setCumulativeBatch(cumulativeBatch);
        vo.setCumulativeCollection(cumulativeCollection);

        vo.setContractId(contractId);

        return vo;
    }
}
