package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.CreditorsrightsEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.bean.MonthlyapprovalEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.vo.CreditorsrightsVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.InterimsettlementEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementService;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;

/**
 * 项目期中结算台账
 *
 * @author generator
 */
@Controller
@RequestMapping("interimsettlement")
public class InterimsettlementController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInterimsettlementService service;

    @Autowired
    private IInterimsettlementdetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InterimsettlementVO> saveOrUpdate(@RequestBody InterimsettlementVO saveorUpdateVO) {
        InterimsettlementEntity entity = BeanMapper.map(saveorUpdateVO, InterimsettlementEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        service.saveOrUpdate(entity, false);
        InterimsettlementVO vo = BeanMapper.map(entity, InterimsettlementVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InterimsettlementVO> queryDetail(Long id) {
        InterimsettlementEntity entity = service.selectById(id);
        InterimsettlementVO vo = BeanMapper.map(entity, InterimsettlementVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InterimsettlementVO> vos) {
        service.removeByIds(vos.stream().map(InterimsettlementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InterimsettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");

        /** 租户隔离 */
       /* param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));*/

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
     /*   param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
*/
        IPage<InterimsettlementEntity> page = service.queryPage(param, false);
        IPage<InterimsettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InterimsettlementVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InterimsettlementEntity> list = service.queryList(param);
        //时间转换
        List<InterimsettlementVO> interimsettlementVOList = BeanMapper.mapList(list, InterimsettlementVO.class);
        for (int i = 0; i < interimsettlementVOList.size(); i++) {
            InterimsettlementVO interimsettlementVO = interimsettlementVOList.get(i);
            interimsettlementVO.setSort(String.valueOf(i + 1));
            if (interimsettlementVO.getApplicationTime() != null) {
                interimsettlementVO.setApplicationTime(DateUtil.date(interimsettlementVO.getApplicationTime()));
            }
            if (interimsettlementVO.getApprovalTime() != null) {
                interimsettlementVO.setApprovalTime(DateUtil.date(interimsettlementVO.getApplicationTime()));
            }
            String billStateStr = interimsettlementVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }
                interimsettlementVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", interimsettlementVOList);
        ExcelExport.getInstance().export("interimsettlementList-export.xlsx", beans, response);

    }

    /**
     * 参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return CommonResponse<IPage < InterimsettlementVO>>
     */
    @RequestMapping(value = "/refInterimsettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InterimsettlementVO>> refInterimsettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InterimsettlementEntity> page = service.queryPage(param, false);
        IPage<InterimsettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InterimsettlementVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InterimsettlementdetailVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            InterimsettlementEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private InterimsettlementdetailVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器-子表数据筛选
        QueryWrapper<InterimsettlementdetailEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("bill_state", 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<InterimsettlementdetailEntity> list = detailService.list(queryWrapperTotal);

        //用来查询所选合同金额--主表
        QueryWrapper<InterimsettlementEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        List<InterimsettlementEntity> masterEntity1 = service.list(wrapper);

        BigDecimal currentApprovalTal = new BigDecimal(0);
        BigDecimal cumulativeApproval = new BigDecimal(0);
        BigDecimal cumulativeReceivable = new BigDecimal(0);
        BigDecimal cumulativeRetention = new BigDecimal(0);
        BigDecimal cumulativeActual = new BigDecimal(0);
        BigDecimal cumulativeUncollected = new BigDecimal(0);

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                InterimsettlementdetailEntity entity = list.get(i);
                currentApprovalTal = currentApprovalTal.add(entity.getCurrentApproval() == null ? BigDecimal.valueOf(0) : entity.getCurrentApproval());
                cumulativeApproval = cumulativeApproval.add(entity.getCumulativeApproval() == null ? BigDecimal.valueOf(0) : entity.getCumulativeApproval());
                cumulativeReceivable = cumulativeReceivable.add(entity.getCumulativeReceivable() == null ? BigDecimal.valueOf(0) : entity.getCumulativeReceivable());
                cumulativeRetention = cumulativeRetention.add(entity.getCumulativeRetention() == null ? BigDecimal.valueOf(0) : entity.getCumulativeRetention());
                cumulativeActual = cumulativeActual.add(entity.getCumulativeActual() == null ? BigDecimal.valueOf(0) : entity.getCumulativeActual() );
                cumulativeUncollected = cumulativeUncollected.add(entity.getCumulativeUncollected() == null ? BigDecimal.valueOf(0) : entity.getCumulativeUncollected());
            }
        }
        InterimsettlementdetailVO vo = new InterimsettlementdetailVO();
        vo.setContractAmount(masterEntity1.get(0).getContractAmount());
        vo.setCumulativeAmount(currentApprovalTal == null ? BigDecimal.valueOf(0) : currentApprovalTal);
        vo.setCumulativeApproval(cumulativeApproval == null ? BigDecimal.valueOf(0) : cumulativeApproval);
        vo.setCumulativeReceivable(cumulativeReceivable == null ? BigDecimal.valueOf(0) : cumulativeReceivable);
        vo.setCumulativeRetention(cumulativeRetention == null ? BigDecimal.valueOf(0) : cumulativeRetention);
        vo.setCumulativeActual(cumulativeActual == null ? BigDecimal.valueOf(0) : cumulativeActual);
        vo.setCumulativeUncollected(cumulativeUncollected == null ? BigDecimal.valueOf(0) : cumulativeUncollected);
        vo.setContractId(contractId);

        return vo;
    }
}
