package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;

/**
 * 月度机械设备租赁单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("mechanicallease")
public class MechanicalleaseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMechanicalleaseService service;

    @Autowired
    private IMechanicalleasedetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> saveOrUpdate(@RequestBody MechanicalleaseVO saveorUpdateVO) {
    	MechanicalleaseEntity entity = BeanMapper.map(saveorUpdateVO, MechanicalleaseEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                Date currentDate = new Date(System.currentTimeMillis());
                if(saveorUpdateVO.getCreateTime() != null){
                    currentDate = saveorUpdateVO.getCreateTime();
                }
                MechanicalleaseVO data = getPastTotalData(saveorUpdateVO.getContractId(), currentDate);
               // entity.setProjectName(data.getProjectName());
                entity.setExTaxCumulative(data.getExTaxCumulative().add(saveorUpdateVO.getExTaxThisMonthTotal()));
                entity.setInTaxCumulative(data.getInTaxCumulative().add(saveorUpdateVO.getInTaxThisMonthTotal()));
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

    	service.saveOrUpdate(entity, false);
    	MechanicalleaseVO vo = BeanMapper.map(entity, MechanicalleaseVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> queryDetail(Long id) {
    	MechanicalleaseEntity entity = service.selectById(id);
    	MechanicalleaseVO vo = BeanMapper.map(entity, MechanicalleaseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MechanicalleaseVO> vos) {
        service.removeByIds(vos.stream().map(MechanicalleaseVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");


        /** 租户隔离 */
       /* param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));*/

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<MechanicalleaseEntity> page = service.queryPage(param,false);
        IPage<MechanicalleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MechanicalleaseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MechanicalleaseEntity> list = service.queryList(param);
        //时间转换
        List<MechanicalleaseVO> mechanicalleaseVOList = BeanMapper.mapList(list, MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); i++) {
            MechanicalleaseVO mechanicalleaseVO = mechanicalleaseVOList.get(i);
            mechanicalleaseVO.setSort(String.valueOf(i + 1));
            if (mechanicalleaseVO.getSettlementTime() != null) {
                mechanicalleaseVO.setSettlementTime(DateUtil.date(mechanicalleaseVO.getSettlementTime()));
            }
            if (mechanicalleaseVO.getBillingStartTime() != null) {
                mechanicalleaseVO.setBillingStartTime(DateUtil.date(mechanicalleaseVO.getBillingStartTime()));
            }
            if (mechanicalleaseVO.getBillingEndTime() != null) {
                mechanicalleaseVO.setBillingEndTime(DateUtil.date(mechanicalleaseVO.getBillingEndTime()));
            }
            String billStateStr = mechanicalleaseVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }
                mechanicalleaseVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", mechanicalleaseVOList);
        ExcelExport.getInstance().export("mechanicalleaseList-export.xlsx", beans, response);

    }

    /**
     * 参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refMechanicalleaseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> refMechanicalleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        IPage<MechanicalleaseEntity> page = service.queryPage(param,false);
        IPage<MechanicalleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MechanicalleaseVO> mechanicalleaseVOList = BeanMapper.mapList(page.getRecords(), MechanicalleaseVO.class);
        for (MechanicalleaseVO record : mechanicalleaseVOList) {
            Long mid = record.getId();
            QueryWrapper<MechanicalleasedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("mid", mid);
            List<MechanicalleasedetailEntity> mechanicalleasedetailEntityList = detailService.list(wrapper);
            if(CollectionUtil.isNotEmpty(mechanicalleasedetailEntityList)){
                record.setMechanicalleasedetailEntities(BeanMapper.mapList(mechanicalleasedetailEntityList,MechanicalleasedetailVO.class));
            }
        }
        pageData.setRecords(mechanicalleaseVOList);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            MechanicalleaseEntity mechanicalleaseEntity = service.selectById(id);
            currentDate = mechanicalleaseEntity.getCreateTime();
        }
        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private MechanicalleaseVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器-子表数据筛选
        QueryWrapper<MechanicalleaseEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("bill_state", 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<MechanicalleaseEntity> list = service.list(queryWrapperTotal);


        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        String projectCode = "";
        Long supplierId = null;
        String projectName = "";
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MechanicalleaseEntity entity = list.get(i);
                exTaxCumulative = exTaxCumulative.add(entity.getExTaxCumulative() == null ? BigDecimal.valueOf(0) : entity.getExTaxCumulative());
                inTaxCumulative = inTaxCumulative.add(entity.getInTaxCumulative() == null ? BigDecimal.valueOf(0) : entity.getInTaxCumulative());
            }
            projectCode = list.get(0).getProjectCode();
            supplierId = list.get(0).getSupplierId();
           // projectName = list.get(0).getProjectName();
        }
        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(exTaxCumulative);
        vo.setInTaxCumulative(inTaxCumulative);
        vo.setProjectCode(projectCode);
        vo.setSupplierId(supplierId);
        vo.setContractId(contractId);
       // vo.setProjectName(projectName);
        return vo;
    }
}
