package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.MonthlyapprovalEntity;
import com.ejianc.business.middlemeasurement.service.IMonthlyapprovalService;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;

/**
 * 总包月度计量审批
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthlyapproval")
public class MonthlyapprovalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMonthlyapprovalService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> saveOrUpdate(@RequestBody MonthlyapprovalVO saveorUpdateVO) throws ParseException {
    	MonthlyapprovalEntity entity = BeanMapper.map(saveorUpdateVO, MonthlyapprovalEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){//新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());

            //1.校验（同一合同，如有未审批通过的单据，不允许新增）
            //创建条件构造器
            QueryWrapper<MonthlyapprovalEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
            List<MonthlyapprovalEntity> pro = service.list(queryWrapper);
            if(pro != null && pro.size() > 0){
                throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"总包月度计量计量审批单据\"!");
            }

            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //2.累计（包含本期）
        Date currentDate = new Date(System.currentTimeMillis());
        if(saveorUpdateVO.getCreateTime() != null){
            currentDate = saveorUpdateVO.getCreateTime();
        }
        //获取往期
        MonthlyapprovalVO pastVo = getPastTotalData(saveorUpdateVO.getContractId(), currentDate);
        //本期 + 往期
        BigDecimal cumulativeOriginalContract = saveorUpdateVO.getOriginalContract().add(pastVo.getCumulativeOriginalContract());//原合同部分
        BigDecimal cumulativeChangeVisa = saveorUpdateVO.getChangeVisa().add(pastVo.getCumulativeChangeVisa());//变更签证部分
        BigDecimal cumulativeCompensationReward = saveorUpdateVO.getCompensationReward().add(pastVo.getCumulativeCompensationReward());//补偿奖励部分
        BigDecimal cumulativeTotalComplete = saveorUpdateVO.getThisMonthTotal().add(pastVo.getCumulativeTotalComplete());//合计

        entity.setCumulativeOriginalContract(cumulativeOriginalContract);
        entity.setCumulativeChangeVisa(cumulativeChangeVisa);
        entity.setCumulativeCompensationReward(cumulativeCompensationReward);
        entity.setCumulativeTotalComplete(cumulativeTotalComplete);
        entity.setCumulativeTotal(cumulativeTotalComplete);


    	service.saveOrUpdate(entity, false);
    	MonthlyapprovalVO vo = BeanMapper.map(entity, MonthlyapprovalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> queryDetail(Long id) {
    	MonthlyapprovalEntity entity = service.selectById(id);
    	MonthlyapprovalVO vo = BeanMapper.map(entity, MonthlyapprovalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthlyapprovalVO> vos) {
        service.removeByIds(vos.stream().map(MonthlyapprovalVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthlyapprovalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<MonthlyapprovalEntity> page = service.queryPage(param,false);
        IPage<MonthlyapprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthlyapprovalVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthlyapprovalEntity> list = service.queryList(param);
        //时间转换
        List<MonthlyapprovalVO> monthlyapprovalList = BeanMapper.mapList(list, MonthlyapprovalVO.class);
        for (int i = 0; i < monthlyapprovalList.size(); i++) {
            MonthlyapprovalVO monthlyapprovalVO = monthlyapprovalList.get(i);
            monthlyapprovalVO.setSort(String.valueOf(i+1));
            if (monthlyapprovalVO.getMeasurementTime()!=null){
                monthlyapprovalVO.setMeasurementTimeShow(DateUtils.dateSimple2(monthlyapprovalVO.getMeasurementTime()));
            }

            String billStateStr = monthlyapprovalVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                monthlyapprovalVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", monthlyapprovalList);
        ExcelExport.getInstance().export("MonthlyapprovalMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMonthlyapprovalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthlyapprovalVO>> refMonthlyapprovalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthlyapprovalEntity> page = service.queryPage(param,false);
        IPage<MonthlyapprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthlyapprovalVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description  查询往期
     * @param contractId
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if(id != null && "".equals(id)){//更新
            MonthlyapprovalEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     */
    private MonthlyapprovalVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器
        QueryWrapper<MonthlyapprovalEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<MonthlyapprovalEntity> proTotal = service.list(queryWrapperTotal);

        BigDecimal cumulativeOriginalContract = new BigDecimal(0);
        BigDecimal cumulativeChangeVisa = new BigDecimal(0);
        BigDecimal cumulativeCompensationReward = new BigDecimal(0);
        BigDecimal cumulativeTotalComplete = new BigDecimal(0);
        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                MonthlyapprovalEntity monthlyapprovalEntity = proTotal.get(i);
                cumulativeOriginalContract = cumulativeOriginalContract.add(monthlyapprovalEntity.getOriginalContract());
                cumulativeChangeVisa = cumulativeChangeVisa.add(monthlyapprovalEntity.getChangeVisa());
                cumulativeCompensationReward = cumulativeCompensationReward.add(monthlyapprovalEntity.getCompensationReward());
                cumulativeTotalComplete = cumulativeTotalComplete.add(monthlyapprovalEntity.getThisMonthTotal());
            }
        }

        MonthlyapprovalVO vo = new MonthlyapprovalVO();
        vo.setCumulativeOriginalContract(cumulativeOriginalContract);
        vo.setCumulativeChangeVisa(cumulativeChangeVisa);
        vo.setCumulativeCompensationReward(cumulativeCompensationReward);
        vo.setCumulativeTotalComplete(cumulativeTotalComplete);
        vo.setCumulativeTotal(cumulativeTotalComplete);
        vo.setContractId(contractId);

        return vo;
    }
}
