package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.MonthlyapprovalEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractvisaEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;

/**
 * 月度物资采购结算单
 *
 * @author generator
 */
@Controller
@RequestMapping("purchasesettlement")
public class PurchasesettlementController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPurchasesettlementService service;
    @Autowired
    private IPurchasesettlementdetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> saveOrUpdate(@RequestBody PurchasesettlementVO saveorUpdateVO) {
        PurchasesettlementEntity entity = BeanMapper.map(saveorUpdateVO, PurchasesettlementEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            //创建条件构造器
            QueryWrapper<PurchasesettlementEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.in("bill_state", 0, 2, 4, 5);//
            List<PurchasesettlementEntity> pro = service.list(queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"月度物资采购结算单\"!");
            }
            //创建条件构造器(校验同一份合同的发生日期)
            QueryWrapper<PurchasesettlementEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.eq("occurrence_time", entity.getOccurrenceTime());//发生日期
            List<PurchasesettlementEntity> list = service.list(queryWrapper);
            if (pro != null && list.size() > 0) {
                throw new BusinessException("相同合同的发生日期不允许重复!");
            }

            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        /*//获取往期累计发生
        Date currentDate = new Date(System.currentTimeMillis());
        if (saveorUpdateVO.getCreateTime() != null) {
            currentDate = saveorUpdateVO.getCreateTime();
        }
        PurchasesettlementVO pastTotalData = getPastTotalData(saveorUpdateVO.getContractId(), currentDate);
        //本期合计+往期累计
        BigDecimal occurrenceTotal = saveorUpdateVO.getMonthlyTotal().add(pastTotalData.getOccurrenceTotal());//累计发生除税
        BigDecimal taxOccurrenceTotal = saveorUpdateVO.getTaxMonthlyTotal().add(pastTotalData.getTaxOccurrenceTotal());//累计发生含税
        entity.setOccurrenceTotal(occurrenceTotal);
        entity.setTaxOccurrenceTotal(taxOccurrenceTotal);*/
        //查询子表累计结算金额
        BigDecimal settlementTotal = new BigDecimal(0); //累计结算金额含税
        BigDecimal taxSettlementTotal = new BigDecimal(0); //累计结算金额含税
        QueryWrapper<PurchasesettlementdetailEntity> detailQueryWrapper = new QueryWrapper<>();
        detailQueryWrapper.eq("contract_id", saveorUpdateVO.getContractId());
        detailQueryWrapper.in("bill_state", 1, 3);
        detailQueryWrapper.eq("bill_code", saveorUpdateVO.getMaterialCode());
        List<PurchasesettlementdetailEntity> list = detailService.list(detailQueryWrapper);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesettlementdetailEntity detailEntity = list.get(i);
                settlementTotal = settlementTotal.add(detailEntity.getSettlementAmount());
                taxSettlementTotal = taxSettlementTotal.add(detailEntity.getTaxSettlementAmount());
            }
        }
        List<PurchasesettlementdetailEntity> detailEntities = entity.getPurchasesettlementdetailEntities();
        if (detailEntities != null && detailEntities.size() > 0) {
            for (int i = 0; i < detailEntities.size(); i++) {
                PurchasesettlementdetailEntity purchasesettlementdetailEntity = detailEntities.get(i);
                purchasesettlementdetailEntity.setSettlementTotal(settlementTotal);
                purchasesettlementdetailEntity.setTaxSettlementTotal(taxSettlementTotal);
            }
        }
        entity.setPurchasesettlementdetailEntities(detailEntities);
        entity.setIsReference(0);
        service.saveOrUpdate(entity, false);
        PurchasesettlementVO vo = BeanMapper.map(entity, PurchasesettlementVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> queryDetail(Long id) {
        PurchasesettlementEntity entity = service.selectById(id);
        PurchasesettlementVO vo = BeanMapper.map(entity, PurchasesettlementVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasesettlementVO> vos) {
        service.removeByIds(vos.stream().map(PurchasesettlementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("settlementType");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PurchasesettlementEntity> page = service.queryPage(param, false);
        IPage<PurchasesettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasesettlementVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("settlementType");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchasesettlementEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Purchasesettlement-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchasesettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> refPurchasesettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchasesettlementEntity> page = service.queryPage(param, false);
        IPage<PurchasesettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasesettlementVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param contractId
     * @Description 查询往期
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            PurchasesettlementEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private PurchasesettlementVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器
        QueryWrapper<PurchasesettlementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("bill_state", 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<PurchasesettlementEntity> proTotal = service.list(queryWrapperTotal);

        BigDecimal occurrenceTotal = new BigDecimal(0); //累计发生除税
        BigDecimal taxOccurrenceTotal = new BigDecimal(0); //累计发生含税
/*
        BigDecimal settlementTotal = new BigDecimal(0); //累计结算金额含税
        BigDecimal taxSettlementTotal = new BigDecimal(0); //累计结算金额含税*/
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); i++) {
                PurchasesettlementEntity purchasesettlementEntity = proTotal.get(i);
                occurrenceTotal = occurrenceTotal.add(purchasesettlementEntity.getMonthlyTotal());
                taxOccurrenceTotal = taxOccurrenceTotal.add(purchasesettlementEntity.getTaxMonthlyTotal());

            }
        }
     /*   List<PurchasesettlementdetailEntity> list = detailService.list(detailQueryWrapper);
        if (list != null&&list.size()>0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesettlementdetailEntity entity = list.get(i);
                settlementTotal=settlementTotal.add(entity.getSettlementAmount());
                taxSettlementTotal= taxSettlementTotal.add(entity.getTaxSettlementAmount());
            }
        }*/
        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);
    /*    vo.setSettlementTotal(settlementTotal);
        vo.setTaxSettlementTotal(taxSettlementTotal);*/
        vo.setContractId(contractId);


        return vo;
    }
}
