package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;

/**
 * 月度周转工具租赁费结算单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("revolvinglease")
public class RevolvingleaseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRevolvingleaseService service;

    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> saveOrUpdate(@RequestBody RevolvingleaseVO saveorUpdateVO) {
    	RevolvingleaseEntity entity = BeanMapper.map(saveorUpdateVO, RevolvingleaseEntity.class);
        entity.setSaveTime(new Date());

        //1.校验（同一合同，结算时间月份不允许重复）
        //创建条件构造器
        QueryWrapper<RevolvingleaseEntity> queryWrapperDate = new QueryWrapper<>();
        queryWrapperDate.eq("contract_id", entity.getContractId());
        queryWrapperDate.eq("settle_time", entity.getSettleTime());
        List<RevolvingleaseEntity> proDate = service.list(queryWrapperDate);

    	if(entity.getId() == null || entity.getId() == 0){
            if(proDate != null && proDate.size() > 0){
                throw new BusinessException("同一合同结算时间月份不允许重复!");
            }

            //2.校验（同一合同，如有未审批通过的单据，不允许新增）
            //创建条件构造器
            QueryWrapper<RevolvingleaseEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.in("bill_state", 0, 2, 4, 5);
            List<RevolvingleaseEntity> pro = service.list(queryWrapper);
            if(pro != null && pro.size() > 0){
                throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"月度周转结算单\"!");
            }

            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setIsReference(0);
        }else {
            if(proDate != null){
                if(proDate.size() > 1 || (proDate.size() == 1 && !proDate.get(0).getId().equals(entity.getId()))){
                    throw new BusinessException("同一合同结算时间月份不允许重复!");
                }
            }
        }

        //3.累计（包含本期）
        Date currentDate = new Date(System.currentTimeMillis());
        if(saveorUpdateVO.getCreateTime() != null){
            currentDate = saveorUpdateVO.getCreateTime();
        }
        //获取往期
        RevolvingleaseVO pastVo = getPastTotalData(saveorUpdateVO.getContractId(), currentDate, true);
        //本期 + 往期（主表）
        BigDecimal occurrenceTotal = saveorUpdateVO.getTotal().add(pastVo.getOccurrenceTotal());
        BigDecimal taxOccurrenceTotal = saveorUpdateVO.getTaxTotal().add(pastVo.getTaxOccurrenceTotal());
        entity.setOccurrenceTotal(occurrenceTotal);
        entity.setTaxOccurrenceTotal(taxOccurrenceTotal);

        //本期 + 往期（子表）
        List<RevolvingleasedetailVO> saveRevolvingleasedetailEntities = saveorUpdateVO.getRevolvingleasedetailEntities();
        List<RevolvingleasedetailVO> revolvingleasedetailVOList =  pastVo.getRevolvingleasedetailEntities();
        if(saveRevolvingleasedetailEntities != null && revolvingleasedetailVOList != null){
            //本期
            for (int i = 0; i < saveRevolvingleasedetailEntities.size(); i++) {
                RevolvingleasedetailVO saveRevolvingleasedetailVO = saveRevolvingleasedetailEntities.get(i);
                //物料编码
                String saveMaterialCode = saveRevolvingleasedetailVO.getMaterialCode();
                //月度结算费用((除税)(元)
                BigDecimal saveMonthlyExpenses = saveRevolvingleasedetailVO.getMonthlyExpenses();
                //月度结算费用（含税）（元）
                BigDecimal saveTaxMonthlyExpenses = saveRevolvingleasedetailVO.getTaxMonthlyExpenses();

                //往期
                for (int j = 0; j < revolvingleasedetailVOList.size(); j++) {
                    RevolvingleasedetailVO revolvingleasedetailVO = revolvingleasedetailVOList.get(j);
                    String materialCode = revolvingleasedetailVO.getMaterialCode();
                    if(materialCode.equals(saveMaterialCode)){
                        //月度结算费用((除税)(元)
                        BigDecimal monthlyExpenses = revolvingleasedetailVO.getMonthlyExpenses();
                        saveMonthlyExpenses = saveMonthlyExpenses.add(monthlyExpenses);

                        //月度结算费用(含税)(元)
                        BigDecimal taxMonthlyExpenses = revolvingleasedetailVO.getTaxMonthlyExpenses();
                        saveTaxMonthlyExpenses = saveTaxMonthlyExpenses.add(taxMonthlyExpenses);
                    }
                }

                saveRevolvingleasedetailVO.setCumulativeAmount(saveMonthlyExpenses);
                saveRevolvingleasedetailVO.setTaxCumulativeAmount(saveTaxMonthlyExpenses);
            }

            entity.setRevolvingleasedetailEntities(BeanMapper.mapList(saveRevolvingleasedetailEntities, RevolvingleasedetailEntity.class));
        }

    	service.saveOrUpdate(entity, false);
    	RevolvingleaseVO vo = BeanMapper.map(entity, RevolvingleaseVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> queryDetail(Long id) {
    	RevolvingleaseEntity entity = service.selectById(id);
    	RevolvingleaseVO vo = BeanMapper.map(entity, RevolvingleaseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RevolvingleaseVO> vos) {
        service.removeByIds(vos.stream().map(RevolvingleaseVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RevolvingleaseVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<RevolvingleaseEntity> page = service.queryPage(param,false);
        IPage<RevolvingleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RevolvingleaseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RevolvingleaseEntity> list = service.queryList(param);
        //时间转换
        List<RevolvingleaseVO> revolvingleaseVOList = BeanMapper.mapList(list, RevolvingleaseVO.class);
        for (int i = 0; i < revolvingleaseVOList.size(); i++) {
            RevolvingleaseVO revolvingleaseVO = revolvingleaseVOList.get(i);
            revolvingleaseVO.setSort(String.valueOf(i+1));
            if (revolvingleaseVO.getSettleTime()!=null){
                revolvingleaseVO.setSettleTimeShow(DateUtils.dateSimple2(revolvingleaseVO.getSettleTime()));
            }
            if (revolvingleaseVO.getStartTime()!=null){
                revolvingleaseVO.setStartTimeShow(DateUtils.dateSimple2(revolvingleaseVO.getStartTime()));
            }
            if (revolvingleaseVO.getDeadline()!=null){
                revolvingleaseVO.setDeadlineShow(DateUtils.dateSimple2(revolvingleaseVO.getDeadline()));
            }

            String billStateStr = revolvingleaseVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                revolvingleaseVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", revolvingleaseVOList);
        ExcelExport.getInstance().export("RevolvingleaseMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refRevolvingleaseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RevolvingleaseVO>> refRevolvingleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }

        //未被引用
        param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        IPage<RevolvingleaseEntity> page = service.queryPage(param,false);
        IPage<RevolvingleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<RevolvingleaseVO> revolvingleaseVOList = BeanMapper.mapList(page.getRecords(), RevolvingleaseVO.class);
        for (int i = 0; i < revolvingleaseVOList.size(); i++) {
            RevolvingleaseVO revolvingleaseVO = revolvingleaseVOList.get(i);
            revolvingleaseVO.setSort(String.valueOf(i + 1));

            QueryWrapper<RevolvingleasedetailEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("mid", revolvingleaseVO.getId());
            List<RevolvingleasedetailEntity> entityList = revolvingleasedetailService.list(detailWrapper);
            if (entityList != null && entityList.size() > 0) {

                List<RevolvingleasedetailVO> detailList = BeanMapper.mapList(entityList, RevolvingleasedetailVO.class);
                revolvingleaseVO.setRevolvingleasedetailEntities(detailList);
            }
        }
        pageData.setRecords(revolvingleaseVOList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description  查询往期
     * @param contractId
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if(id != null && "".equals(id)){//更新
            RevolvingleaseEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate, false));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     * @param isSave true保存 false查询
     * @return
     */
    private RevolvingleaseVO getPastTotalData(Long contractId, Date currentDate, boolean isSave) {
        //创建条件构造器
        QueryWrapper<RevolvingleaseEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<RevolvingleaseEntity> proTotal = service.list(queryWrapperTotal);
        List<RevolvingleasedetailEntity> revolvingleasedetailEntityList = new ArrayList<>();

        //累计发生(除税)
        BigDecimal occurrenceTotal = new BigDecimal(0);
        //累计发生(含税)
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);

        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                RevolvingleaseEntity revolvingleaseEntity = proTotal.get(i);
                occurrenceTotal = occurrenceTotal.add(revolvingleaseEntity.getTotal());
                taxOccurrenceTotal = taxOccurrenceTotal.add(revolvingleaseEntity.getTaxTotal());

                if(isSave){
                    QueryWrapper<RevolvingleasedetailEntity> detailWrapper = new QueryWrapper<>();
                    detailWrapper.eq("mid", revolvingleaseEntity.getId());
                    List<RevolvingleasedetailEntity> detailList = revolvingleasedetailService.list(detailWrapper);
                    revolvingleasedetailEntityList.addAll(detailList);
                }
            }
        }

        RevolvingleaseVO vo = new RevolvingleaseVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);

        vo.setContractId(contractId);
        //往期所有子表 entity和vo转换
        vo.setRevolvingleasedetailEntities(BeanMapper.mapList(revolvingleasedetailEntityList, RevolvingleasedetailVO.class));

        return vo;
    }
}
