package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractaccountEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountService;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

/**
 * 分包月度报量台账
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("subcontractaccount")
public class SubcontractaccountController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;

	private static final String BILL_CODE = "subcontractaccount_Open_Apply_Code";// 此处需要根据实际修改

	@Autowired
	private ISubcontractaccountService service;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SubcontractaccountVO> saveOrUpdate(@RequestBody SubcontractaccountVO saveorUpdateVO) {
		SubcontractaccountEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractaccountEntity.class);
		if (entity.getId() == null || entity.getId() == 0) {
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,
					InvocationInfoProxy.getTenantid());
			if (billCode.isSuccess()) {
				// entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
				entity.setBillCode(billCode.getData());// 此处需要根据实际修改 删除本行或者上一行
			} else {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}
		service.saveOrUpdate(entity, false);
		SubcontractaccountVO vo = BeanMapper.map(entity, SubcontractaccountVO.class);
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractaccountVO> queryDetail(Long id) {
		SubcontractaccountEntity entity = service.selectById(id);
		SubcontractaccountVO vo = BeanMapper.map(entity, SubcontractaccountVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<SubcontractaccountVO> vos) {
		service.removeByIds(vos.stream().map(SubcontractaccountVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SubcontractaccountVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
		param.getParams().put("orgId",
				new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
						.stream().map(OrgVO::getId).collect(Collectors.toList())));

		IPage<SubcontractaccountEntity> page = service.queryPage(param, false);
		IPage<SubcontractaccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractaccountVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * @Description 导出
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);
		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
		param.getParams().put("orgId",
				new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
						.stream().map(OrgVO::getId).collect(Collectors.toList())));
		List<SubcontractaccountEntity> list = service.queryList(param);
		// todo:字段翻译等等
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", list);
		ExcelExport.getInstance().export("subcontractaccount-export.xlsx", beans, response);
	}

	/**
	 * @Description 参照
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/refSubcontractaccountData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<SubcontractaccountVO>> refSubcontractaccountData(@RequestParam Integer pageNumber,
			@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
		QueryParam param = new QueryParam();
		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
		}

		IPage<SubcontractaccountEntity> page = service.queryPage(param, false);
		IPage<SubcontractaccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractaccountVO.class));

		return CommonResponse.success("查询参照数据成功！", pageData);
	}
}
